/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.graphics.Rect;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imageformat.ImageFormatChecker;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imageutils.JfifUtil;
import java.io.IOException;
import java.io.InputStream;

public class AddImageTransformMetaDataProducer
implements Producer<EncodedImage> {
    private final Producer<EncodedImage> mNextProducer;

    public AddImageTransformMetaDataProducer(Producer<EncodedImage> nextProducer) {
        this.mNextProducer = nextProducer;
    }

    @Override
    public void produceResults(Consumer<EncodedImage> consumer, ProducerContext context) {
        this.mNextProducer.produceResults(new AddImageTransformMetaDataConsumer(consumer), context);
    }

    private static EncodedImage setEncodedImageMetaData(EncodedImage encodedImage) {
        Rect dimensions;
        ImageFormat imageFormat = ImageFormatChecker.getImageFormat_WrapIOException(encodedImage.getInputStream());
        encodedImage.setImageFormat(imageFormat);
        if (imageFormat == ImageFormat.JPEG && (dimensions = JfifUtil.getDimensions(encodedImage.getInputStream())) != null) {
            encodedImage.setRotationAngle(AddImageTransformMetaDataProducer.getRotationAngle(encodedImage));
            encodedImage.setWidth(dimensions.width());
            encodedImage.setHeight(dimensions.height());
        }
        return encodedImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getRotationAngle(EncodedImage encodedImage) {
        InputStream is = encodedImage.getInputStream();
        try {
            int n = JfifUtil.getAutoRotateAngleFromOrientation(JfifUtil.getOrientation(is));
            return n;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        }
    }

    private static class AddImageTransformMetaDataConsumer
    extends DelegatingConsumer<EncodedImage, EncodedImage> {
        private AddImageTransformMetaDataConsumer(Consumer<EncodedImage> consumer) {
            super(consumer);
        }

        @Override
        protected void onNewResultImpl(EncodedImage newResult, boolean isLast) {
            if (newResult == null) {
                this.getConsumer().onNewResult(null, isLast);
                return;
            }
            EncodedImage encodedImage = AddImageTransformMetaDataProducer.setEncodedImageMetaData(newResult);
            this.getConsumer().onNewResult(encodedImage, isLast);
        }
    }
}

