/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.cache.common.CacheKey;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.cache.CacheKeyFactory;
import com.facebook.imagepipeline.cache.MemoryCache;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.QualityInfo;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener;
import com.facebook.imagepipeline.request.ImageRequest;

public class BitmapMemoryCacheProducer
implements Producer<CloseableReference<CloseableImage>> {
    @VisibleForTesting
    static final String PRODUCER_NAME = "BitmapMemoryCacheProducer";
    @VisibleForTesting
    static final String VALUE_FOUND = "cached_value_found";
    private final MemoryCache<CacheKey, CloseableImage> mMemoryCache;
    private final CacheKeyFactory mCacheKeyFactory;
    private final Producer<CloseableReference<CloseableImage>> mNextProducer;

    public BitmapMemoryCacheProducer(MemoryCache<CacheKey, CloseableImage> memoryCache, CacheKeyFactory cacheKeyFactory, Producer<CloseableReference<CloseableImage>> nextProducer) {
        this.mMemoryCache = memoryCache;
        this.mCacheKeyFactory = cacheKeyFactory;
        this.mNextProducer = nextProducer;
    }

    @Override
    public void produceResults(Consumer<CloseableReference<CloseableImage>> consumer, ProducerContext producerContext) {
        ProducerListener listener = producerContext.getListener();
        String requestId = producerContext.getId();
        listener.onProducerStart(requestId, this.getProducerName());
        ImageRequest imageRequest = producerContext.getImageRequest();
        CacheKey cacheKey = this.mCacheKeyFactory.getBitmapCacheKey(imageRequest);
        CloseableReference<CloseableImage> cachedReference = this.mMemoryCache.get(cacheKey);
        if (cachedReference != null) {
            boolean isFinal = ((CloseableImage)cachedReference.get()).getQualityInfo().isOfFullQuality();
            if (isFinal) {
                listener.onProducerFinishWithSuccess(requestId, this.getProducerName(), listener.requiresExtraMap(requestId) ? ImmutableMap.of((Object)VALUE_FOUND, (Object)"true") : null);
                consumer.onProgressUpdate(1.0f);
            }
            consumer.onNewResult(cachedReference, isFinal);
            cachedReference.close();
            if (isFinal) {
                return;
            }
        }
        if (producerContext.getLowestPermittedRequestLevel().getValue() >= ImageRequest.RequestLevel.BITMAP_MEMORY_CACHE.getValue()) {
            listener.onProducerFinishWithSuccess(requestId, this.getProducerName(), listener.requiresExtraMap(requestId) ? ImmutableMap.of((Object)VALUE_FOUND, (Object)"false") : null);
            consumer.onNewResult(null, true);
            return;
        }
        Consumer<CloseableReference<CloseableImage>> wrappedConsumer = this.wrapConsumer(consumer, cacheKey);
        listener.onProducerFinishWithSuccess(requestId, this.getProducerName(), listener.requiresExtraMap(requestId) ? ImmutableMap.of((Object)VALUE_FOUND, (Object)"false") : null);
        this.mNextProducer.produceResults(wrappedConsumer, producerContext);
    }

    protected Consumer<CloseableReference<CloseableImage>> wrapConsumer(Consumer<CloseableReference<CloseableImage>> consumer, final CacheKey cacheKey) {
        return new DelegatingConsumer<CloseableReference<CloseableImage>, CloseableReference<CloseableImage>>(consumer){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNewResultImpl(CloseableReference<CloseableImage> newResult, boolean isLast) {
                CloseableReference currentCachedResult;
                if (newResult == null) {
                    if (isLast) {
                        this.getConsumer().onNewResult(null, true);
                    }
                    return;
                }
                if (((CloseableImage)newResult.get()).isStateful()) {
                    this.getConsumer().onNewResult(newResult, isLast);
                    return;
                }
                if (!isLast && (currentCachedResult = BitmapMemoryCacheProducer.this.mMemoryCache.get(cacheKey)) != null) {
                    try {
                        QualityInfo newInfo = ((CloseableImage)newResult.get()).getQualityInfo();
                        QualityInfo cachedInfo = ((CloseableImage)currentCachedResult.get()).getQualityInfo();
                        if (cachedInfo.isOfFullQuality() || cachedInfo.getQuality() >= newInfo.getQuality()) {
                            this.getConsumer().onNewResult(currentCachedResult, false);
                            return;
                        }
                    }
                    finally {
                        CloseableReference.closeSafely(currentCachedResult);
                    }
                }
                CloseableReference<CloseableImage> newCachedResult = BitmapMemoryCacheProducer.this.mMemoryCache.cache(cacheKey, newResult);
                try {
                    if (isLast) {
                        this.getConsumer().onProgressUpdate(1.0f);
                    }
                    this.getConsumer().onNewResult(newCachedResult != null ? newCachedResult : newResult, isLast);
                }
                finally {
                    CloseableReference.closeSafely(newCachedResult);
                }
            }
        };
    }

    protected String getProducerName() {
        return PRODUCER_NAME;
    }
}

