/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.content.res.AssetFileDescriptor;
import android.content.res.AssetManager;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.imagepipeline.memory.PooledByteBufferFactory;
import com.facebook.imagepipeline.producers.LocalFetchProducer;
import com.facebook.imagepipeline.request.ImageRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;

public class LocalAssetFetchProducer
extends LocalFetchProducer {
    @VisibleForTesting
    static final String PRODUCER_NAME = "LocalAssetFetchProducer";
    private final AssetManager mAssetManager;

    public LocalAssetFetchProducer(Executor executor, PooledByteBufferFactory pooledByteBufferFactory, AssetManager assetManager) {
        super(executor, pooledByteBufferFactory);
        this.mAssetManager = assetManager;
    }

    @Override
    protected InputStream getInputStream(ImageRequest imageRequest) throws IOException {
        return this.mAssetManager.open(LocalAssetFetchProducer.getAssetName(imageRequest), 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getLength(ImageRequest imageRequest) {
        AssetFileDescriptor fd = null;
        try {
            fd = this.mAssetManager.openFd(LocalAssetFetchProducer.getAssetName(imageRequest));
            int n = (int)fd.getLength();
            return n;
        }
        catch (IOException e) {
            int n = -1;
            return n;
        }
        finally {
            try {
                if (fd != null) {
                    fd.close();
                }
            }
            catch (IOException ignored) {}
        }
    }

    @Override
    protected String getProducerName() {
        return PRODUCER_NAME;
    }

    private static String getAssetName(ImageRequest imageRequest) {
        return imageRequest.getSourceUri().getPath().substring(1);
    }
}

