/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener;
import com.facebook.imagepipeline.producers.StatefulProducerRunnable;
import java.util.concurrent.Executor;

public class ThreadHandoffProducer<T>
implements Producer<T> {
    @VisibleForTesting
    protected static final String PRODUCER_NAME = "BackgroundThreadHandoffProducer";
    private final Executor mExecutor;
    private final Producer<T> mNextProducer;

    public ThreadHandoffProducer(Executor executorService, Producer<T> nextProducer) {
        this.mExecutor = (Executor)Preconditions.checkNotNull((Object)executorService);
        this.mNextProducer = (Producer)Preconditions.checkNotNull(nextProducer);
    }

    @Override
    public void produceResults(final Consumer<T> consumer, final ProducerContext context) {
        final ProducerListener producerListener = context.getListener();
        final String requestId = context.getId();
        final StatefulProducerRunnable statefulRunnable = new StatefulProducerRunnable<T>(consumer, producerListener, PRODUCER_NAME, requestId){

            @Override
            protected void onSuccess(T ignored) {
                producerListener.onProducerFinishWithSuccess(requestId, ThreadHandoffProducer.PRODUCER_NAME, null);
                ThreadHandoffProducer.this.mNextProducer.produceResults(consumer, context);
            }

            @Override
            protected void disposeResult(T ignored) {
            }

            protected T getResult() throws Exception {
                return null;
            }
        };
        context.addCallbacks(new BaseProducerContextCallbacks(){

            @Override
            public void onCancellationRequested() {
                statefulRunnable.cancel();
            }
        });
        this.mExecutor.execute((Runnable)((Object)statefulRunnable));
    }
}

