/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.common.internal.Supplier;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.memory.PooledByteBufferFactory;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DownsampleUtil;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener;
import com.facebook.imagepipeline.producers.StatefulProducerRunnable;
import com.facebook.imagepipeline.request.ImageRequest;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Executor;

public abstract class LocalFetchProducer
implements Producer<EncodedImage> {
    private final Executor mExecutor;
    private final PooledByteBufferFactory mPooledByteBufferFactory;
    private final boolean mDownsampleEnabled;

    protected LocalFetchProducer(Executor executor, PooledByteBufferFactory pooledByteBufferFactory, boolean downsampleEnabled) {
        this.mExecutor = executor;
        this.mPooledByteBufferFactory = pooledByteBufferFactory;
        this.mDownsampleEnabled = downsampleEnabled;
    }

    @Override
    public void produceResults(Consumer<EncodedImage> consumer, ProducerContext producerContext) {
        ProducerListener listener = producerContext.getListener();
        String requestId = producerContext.getId();
        final ImageRequest imageRequest = producerContext.getImageRequest();
        final StatefulProducerRunnable<EncodedImage> cancellableProducerRunnable = new StatefulProducerRunnable<EncodedImage>(consumer, listener, this.getProducerName(), requestId){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected EncodedImage getResult() throws Exception {
                EncodedImage encodedImage;
                block8: {
                    encodedImage = LocalFetchProducer.this.getEncodedImage(imageRequest);
                    encodedImage.parseMetaData();
                    if (LocalFetchProducer.this.mDownsampleEnabled && EncodedImage.isMetaDataAvailable(encodedImage)) {
                        encodedImage.setSampleSize(DownsampleUtil.determineSampleSize(imageRequest, encodedImage));
                    }
                    if (encodedImage.getSampleSize() == 1) {
                        CloseableReference<PooledByteBuffer> bytesRef = encodedImage.getByteBufferRef();
                        try {
                            if (bytesRef != null) break block8;
                            EncodedImage oldEncodedImage = encodedImage;
                            try {
                                encodedImage = LocalFetchProducer.this.getByteBufferBackedEncodedImage(oldEncodedImage.getInputStream(), oldEncodedImage.getSize());
                                encodedImage.copyMetaDataFrom(oldEncodedImage);
                            }
                            finally {
                                EncodedImage.closeSafely(oldEncodedImage);
                            }
                        }
                        finally {
                            CloseableReference.closeSafely(bytesRef);
                        }
                    }
                }
                return encodedImage;
            }

            @Override
            protected void disposeResult(EncodedImage result) {
                EncodedImage.closeSafely(result);
            }
        };
        producerContext.addCallbacks(new BaseProducerContextCallbacks(){

            @Override
            public void onCancellationRequested() {
                cancellableProducerRunnable.cancel();
            }
        });
        this.mExecutor.execute((Runnable)((Object)cancellableProducerRunnable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EncodedImage getByteBufferBackedEncodedImage(InputStream inputStream, int length) throws IOException {
        EncodedImage encodedImage;
        CloseableReference ref = null;
        try {
            ref = length < 0 ? CloseableReference.of((Closeable)this.mPooledByteBufferFactory.newByteBuffer(inputStream)) : CloseableReference.of((Closeable)this.mPooledByteBufferFactory.newByteBuffer(inputStream, length));
            encodedImage = new EncodedImage((CloseableReference<PooledByteBuffer>)ref);
        }
        catch (Throwable throwable) {
            CloseableReference.closeSafely(ref);
            throw throwable;
        }
        CloseableReference.closeSafely((CloseableReference)ref);
        return encodedImage;
    }

    protected EncodedImage getFileBackedEncodedImage(String pathname, int length) {
        return this.getFileBackedEncodedImage(new File(pathname), length);
    }

    protected EncodedImage getFileBackedEncodedImage(final File file, int length) {
        Supplier<FileInputStream> sup = new Supplier<FileInputStream>(){

            public FileInputStream get() {
                try {
                    return new FileInputStream(file);
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        };
        return new EncodedImage(sup, length);
    }

    protected abstract EncodedImage getEncodedImage(ImageRequest var1) throws IOException;

    protected abstract String getProducerName();
}

