/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imageutils;

import android.graphics.Rect;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.logging.FLog;
import com.facebook.imageutils.StreamProcessor;
import java.io.IOException;
import java.io.InputStream;

public class PngUtil {
    private static final String TAG = PngUtil.class.getName();
    private static final int CHUNK_LENGTH_FIELD_SIZE = 4;
    private static final int CHUNK_TYPE_FIELD_SIZE = 4;
    private static final int WIDTH_FIELD_SIZE = 4;
    private static final int HEIGHT_FIELD_SIZE = 4;
    private static final int IHDR_DATA_SIZE = 13;
    private static final byte[] PNG_HEADER = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};

    public static Rect getDimensions(InputStream is) {
        Preconditions.checkNotNull((Object)is);
        try {
            byte[] headerBytes = new byte[PNG_HEADER.length];
            is.read(headerBytes, 0, PNG_HEADER.length);
            if (!PngUtil.matchBytes(headerBytes, PNG_HEADER)) {
                return null;
            }
            int length = StreamProcessor.readPackedInt(is, 4, false);
            if (length >= 13) {
                is.skip(4L);
                int width = StreamProcessor.readPackedInt(is, 4, false);
                int height = StreamProcessor.readPackedInt(is, 4, false);
                return new Rect(0, 0, width, height);
            }
        }
        catch (IOException ioe) {
            FLog.e((String)TAG, (Throwable)ioe, (String)"unable to read dimensions of PNG image", (Object[])new Object[0]);
        }
        return null;
    }

    private static boolean matchBytes(byte[] bytes1, byte[] bytes2) {
        if (bytes1.length != bytes2.length) {
            return false;
        }
        for (int i = 0; i < bytes1.length; ++i) {
            if (bytes1[i] == bytes2[i]) continue;
            return false;
        }
        return true;
    }
}

