/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.bitmaps;

import android.annotation.SuppressLint;
import android.graphics.Bitmap;
import android.os.Build;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.bitmaps.ArtBitmapFactory;
import com.facebook.imagepipeline.bitmaps.DalvikBitmapFactory;
import com.facebook.imagepipeline.bitmaps.GingerbreadBitmapFactory;
import com.facebook.imagepipeline.image.EncodedImage;
import java.util.List;

public class PlatformBitmapFactory {
    private final GingerbreadBitmapFactory mGingerbreadBitmapFactory;
    private final DalvikBitmapFactory mDalvikBitmapFactory;
    private final ArtBitmapFactory mArtBitmapFactory;

    public PlatformBitmapFactory(GingerbreadBitmapFactory gingerbreadBitmapFactory, DalvikBitmapFactory dalvikBitmapFactory, ArtBitmapFactory artBitmapFactory) {
        this.mGingerbreadBitmapFactory = gingerbreadBitmapFactory;
        this.mDalvikBitmapFactory = dalvikBitmapFactory;
        this.mArtBitmapFactory = artBitmapFactory;
    }

    @SuppressLint(value={"NewApi"})
    public CloseableReference<Bitmap> createBitmap(int width, int height) {
        if (Build.VERSION.SDK_INT >= 21) {
            return this.mArtBitmapFactory.createBitmap(width, height);
        }
        if (Build.VERSION.SDK_INT >= 11) {
            return this.mDalvikBitmapFactory.createBitmap((short)width, (short)height);
        }
        return this.mGingerbreadBitmapFactory.createBitmap(width, height);
    }

    public synchronized List<CloseableReference<Bitmap>> associateBitmapsWithBitmapCounter(List<Bitmap> bitmaps) {
        return this.mDalvikBitmapFactory.associateBitmapsWithBitmapCounter(bitmaps);
    }

    public CloseableReference<Bitmap> decodeFromEncodedImage(EncodedImage encodedImage) {
        if (Build.VERSION.SDK_INT >= 21) {
            return this.mArtBitmapFactory.decodeFromEncodedImage(encodedImage);
        }
        return this.mDalvikBitmapFactory.decodeFromEncodedImage(encodedImage);
    }

    public CloseableReference<Bitmap> decodeJPEGFromEncodedImage(EncodedImage encodedImage, int length) {
        if (Build.VERSION.SDK_INT >= 21) {
            return this.mArtBitmapFactory.decodeJPEGFromEncodedImage(encodedImage, length);
        }
        return this.mDalvikBitmapFactory.decodeJPEGFromEncodedImage(encodedImage, length);
    }
}

