/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import android.graphics.Bitmap;
import com.facebook.common.internal.Preconditions;
import com.facebook.imageutils.BitmapUtil;
import javax.annotation.concurrent.GuardedBy;

public class BitmapCounter {
    @GuardedBy(value="this")
    private int mCount;
    @GuardedBy(value="this")
    private long mSize;
    private final int mMaxCount;
    private final int mMaxSize;

    public BitmapCounter(int maxCount, int maxSize) {
        Preconditions.checkArgument((maxCount > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0);
        this.mMaxCount = maxCount;
        this.mMaxSize = maxSize;
    }

    public synchronized boolean increase(Bitmap bitmap) {
        int bitmapSize = BitmapUtil.getSizeInBytes(bitmap);
        if (this.mCount >= this.mMaxCount || this.mSize + (long)bitmapSize > (long)this.mMaxSize) {
            return false;
        }
        ++this.mCount;
        this.mSize += (long)bitmapSize;
        return true;
    }

    public synchronized void decrease(Bitmap bitmap) {
        int bitmapSize = BitmapUtil.getSizeInBytes(bitmap);
        Preconditions.checkArgument((this.mCount > 0 ? 1 : 0) != 0, (Object)"No bitmaps registered.");
        Preconditions.checkArgument(((long)bitmapSize <= this.mSize ? 1 : 0) != 0, (String)"Bitmap size bigger than the total registered size: %d, %d", (Object[])new Object[]{bitmapSize, this.mSize});
        this.mSize -= (long)bitmapSize;
        --this.mCount;
    }

    public synchronized int getCount() {
        return this.mCount;
    }

    public synchronized long getSize() {
        return this.mSize;
    }
}

