/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.core;

import android.net.Uri;
import android.os.Build;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.media.MediaUtils;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.util.UriUtil;
import com.facebook.imagepipeline.core.ProducerFactory;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.memory.PooledByteBuffer;
import com.facebook.imagepipeline.producers.BitmapMemoryCacheKeyMultiplexProducer;
import com.facebook.imagepipeline.producers.BitmapMemoryCacheProducer;
import com.facebook.imagepipeline.producers.DecodeProducer;
import com.facebook.imagepipeline.producers.EncodedMemoryCacheProducer;
import com.facebook.imagepipeline.producers.LocalAssetFetchProducer;
import com.facebook.imagepipeline.producers.LocalContentUriFetchProducer;
import com.facebook.imagepipeline.producers.LocalFileFetchProducer;
import com.facebook.imagepipeline.producers.LocalResourceFetchProducer;
import com.facebook.imagepipeline.producers.LocalVideoThumbnailProducer;
import com.facebook.imagepipeline.producers.NetworkFetcher;
import com.facebook.imagepipeline.producers.PostprocessedBitmapMemoryCacheProducer;
import com.facebook.imagepipeline.producers.PostprocessorProducer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.RemoveImageTransformMetaDataProducer;
import com.facebook.imagepipeline.producers.SwallowResultProducer;
import com.facebook.imagepipeline.producers.ThreadHandoffProducer;
import com.facebook.imagepipeline.producers.ThreadHandoffProducerQueue;
import com.facebook.imagepipeline.producers.ThrottlingProducer;
import com.facebook.imagepipeline.request.ImageRequest;
import java.util.HashMap;
import java.util.Map;

public class ProducerSequenceFactory {
    private static final int MAX_SIMULTANEOUS_FILE_FETCH_AND_RESIZE = 5;
    private final ProducerFactory mProducerFactory;
    private final NetworkFetcher mNetworkFetcher;
    private final boolean mResizeAndRotateEnabledForNetwork;
    private final boolean mWebpSupportEnabled;
    private final boolean mDownsampleEnabled;
    private final ThreadHandoffProducerQueue mThreadHandoffProducerQueue;
    @VisibleForTesting
    Producer<CloseableReference<CloseableImage>> mNetworkFetchSequence;
    @VisibleForTesting
    Producer<EncodedImage> mBackgroundNetworkFetchToEncodedMemorySequence;
    @VisibleForTesting
    Producer<CloseableReference<PooledByteBuffer>> mEncodedImageProducerSequence;
    @VisibleForTesting
    Producer<Void> mNetworkFetchToEncodedMemoryPrefetchSequence;
    private Producer<EncodedImage> mCommonNetworkFetchToEncodedMemorySequence;
    @VisibleForTesting
    Producer<CloseableReference<CloseableImage>> mLocalImageFileFetchSequence;
    @VisibleForTesting
    Producer<CloseableReference<CloseableImage>> mLocalVideoFileFetchSequence;
    @VisibleForTesting
    Producer<CloseableReference<CloseableImage>> mLocalContentUriFetchSequence;
    @VisibleForTesting
    Producer<CloseableReference<CloseableImage>> mLocalResourceFetchSequence;
    @VisibleForTesting
    Producer<CloseableReference<CloseableImage>> mLocalAssetFetchSequence;
    @VisibleForTesting
    Producer<CloseableReference<CloseableImage>> mDataFetchSequence;
    @VisibleForTesting
    Map<Producer<CloseableReference<CloseableImage>>, Producer<CloseableReference<CloseableImage>>> mPostprocessorSequences;
    @VisibleForTesting
    Map<Producer<CloseableReference<CloseableImage>>, Producer<Void>> mCloseableImagePrefetchSequences;

    public ProducerSequenceFactory(ProducerFactory producerFactory, NetworkFetcher networkFetcher, boolean resizeAndRotateEnabledForNetwork, boolean downsampleEnabled, boolean webpSupportEnabled, ThreadHandoffProducerQueue threadHandoffProducerQueue) {
        this.mProducerFactory = producerFactory;
        this.mNetworkFetcher = networkFetcher;
        this.mResizeAndRotateEnabledForNetwork = resizeAndRotateEnabledForNetwork;
        this.mDownsampleEnabled = downsampleEnabled;
        this.mWebpSupportEnabled = webpSupportEnabled;
        this.mPostprocessorSequences = new HashMap<Producer<CloseableReference<CloseableImage>>, Producer<CloseableReference<CloseableImage>>>();
        this.mCloseableImagePrefetchSequences = new HashMap<Producer<CloseableReference<CloseableImage>>, Producer<Void>>();
        this.mThreadHandoffProducerQueue = threadHandoffProducerQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Producer<CloseableReference<PooledByteBuffer>> getEncodedImageProducerSequence(ImageRequest imageRequest) {
        ProducerSequenceFactory.validateEncodedImageRequest(imageRequest);
        ProducerSequenceFactory producerSequenceFactory = this;
        synchronized (producerSequenceFactory) {
            if (this.mEncodedImageProducerSequence == null) {
                this.mEncodedImageProducerSequence = new RemoveImageTransformMetaDataProducer(this.getBackgroundNetworkFetchToEncodedMemorySequence());
            }
        }
        return this.mEncodedImageProducerSequence;
    }

    public Producer<Void> getEncodedImagePrefetchProducerSequence(ImageRequest imageRequest) {
        ProducerSequenceFactory.validateEncodedImageRequest(imageRequest);
        return this.getNetworkFetchToEncodedMemoryPrefetchSequence();
    }

    private static void validateEncodedImageRequest(ImageRequest imageRequest) {
        Preconditions.checkNotNull((Object)imageRequest);
        Preconditions.checkArgument((boolean)UriUtil.isNetworkUri((Uri)imageRequest.getSourceUri()));
        Preconditions.checkArgument((imageRequest.getLowestPermittedRequestLevel().getValue() <= ImageRequest.RequestLevel.ENCODED_MEMORY_CACHE.getValue() ? 1 : 0) != 0);
    }

    public Producer<CloseableReference<CloseableImage>> getDecodedImageProducerSequence(ImageRequest imageRequest) {
        Producer<CloseableReference<CloseableImage>> pipelineSequence = this.getBasicDecodedImageSequence(imageRequest);
        if (imageRequest.getPostprocessor() != null) {
            return this.getPostprocessorSequence(pipelineSequence);
        }
        return pipelineSequence;
    }

    public Producer<Void> getDecodedImagePrefetchProducerSequence(ImageRequest imageRequest) {
        return this.getDecodedImagePrefetchSequence(this.getBasicDecodedImageSequence(imageRequest));
    }

    private Producer<CloseableReference<CloseableImage>> getBasicDecodedImageSequence(ImageRequest imageRequest) {
        Preconditions.checkNotNull((Object)imageRequest);
        Uri uri = imageRequest.getSourceUri();
        Preconditions.checkNotNull((Object)uri, (Object)"Uri is null.");
        if (UriUtil.isNetworkUri((Uri)uri)) {
            return this.getNetworkFetchSequence();
        }
        if (UriUtil.isLocalFileUri((Uri)uri)) {
            if (MediaUtils.isVideo((String)MediaUtils.extractMime((String)uri.getPath()))) {
                return this.getLocalVideoFileFetchSequence();
            }
            return this.getLocalImageFileFetchSequence();
        }
        if (UriUtil.isLocalContentUri((Uri)uri)) {
            return this.getLocalContentUriFetchSequence();
        }
        if (UriUtil.isLocalAssetUri((Uri)uri)) {
            return this.getLocalAssetFetchSequence();
        }
        if (UriUtil.isLocalResourceUri((Uri)uri)) {
            return this.getLocalResourceFetchSequence();
        }
        if (UriUtil.isDataUri((Uri)uri)) {
            return this.getDataFetchSequence();
        }
        String uriString = uri.toString();
        if (uriString.length() > 30) {
            uriString = uriString.substring(0, 30) + "...";
        }
        throw new RuntimeException("Unsupported uri scheme! Uri is: " + uriString);
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getNetworkFetchSequence() {
        if (this.mNetworkFetchSequence == null) {
            this.mNetworkFetchSequence = this.newBitmapCacheGetToDecodeSequence(this.getCommonNetworkFetchToEncodedMemorySequence());
        }
        return this.mNetworkFetchSequence;
    }

    private synchronized Producer<EncodedImage> getBackgroundNetworkFetchToEncodedMemorySequence() {
        if (this.mBackgroundNetworkFetchToEncodedMemorySequence == null) {
            this.mBackgroundNetworkFetchToEncodedMemorySequence = this.mProducerFactory.newBackgroundThreadHandoffProducer(this.getCommonNetworkFetchToEncodedMemorySequence(), this.mThreadHandoffProducerQueue);
        }
        return this.mBackgroundNetworkFetchToEncodedMemorySequence;
    }

    private synchronized Producer<Void> getNetworkFetchToEncodedMemoryPrefetchSequence() {
        if (this.mNetworkFetchToEncodedMemoryPrefetchSequence == null) {
            this.mNetworkFetchToEncodedMemoryPrefetchSequence = ProducerFactory.newSwallowResultProducer(this.getBackgroundNetworkFetchToEncodedMemorySequence());
        }
        return this.mNetworkFetchToEncodedMemoryPrefetchSequence;
    }

    private synchronized Producer<EncodedImage> getCommonNetworkFetchToEncodedMemorySequence() {
        if (this.mCommonNetworkFetchToEncodedMemorySequence == null) {
            Producer<EncodedImage> inputProducer = this.newEncodedCacheMultiplexToTranscodeSequence(this.mProducerFactory.newNetworkFetchProducer(this.mNetworkFetcher));
            this.mCommonNetworkFetchToEncodedMemorySequence = ProducerFactory.newAddImageTransformMetaDataProducer(inputProducer);
            if (this.mResizeAndRotateEnabledForNetwork && !this.mDownsampleEnabled) {
                this.mCommonNetworkFetchToEncodedMemorySequence = this.mProducerFactory.newResizeAndRotateProducer(this.mCommonNetworkFetchToEncodedMemorySequence);
            }
        }
        return this.mCommonNetworkFetchToEncodedMemorySequence;
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getLocalImageFileFetchSequence() {
        if (this.mLocalImageFileFetchSequence == null) {
            LocalFileFetchProducer localFileFetchProducer = this.mProducerFactory.newLocalFileFetchProducer();
            this.mLocalImageFileFetchSequence = this.newBitmapCacheGetToLocalTransformSequence(localFileFetchProducer);
        }
        return this.mLocalImageFileFetchSequence;
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getLocalVideoFileFetchSequence() {
        if (this.mLocalVideoFileFetchSequence == null) {
            LocalVideoThumbnailProducer localVideoThumbnailProducer = this.mProducerFactory.newLocalVideoThumbnailProducer();
            this.mLocalVideoFileFetchSequence = this.newBitmapCacheGetToBitmapCacheSequence(localVideoThumbnailProducer);
        }
        return this.mLocalVideoFileFetchSequence;
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getLocalContentUriFetchSequence() {
        if (this.mLocalContentUriFetchSequence == null) {
            LocalContentUriFetchProducer localContentUriFetchProducer = this.mProducerFactory.newContentUriFetchProducer();
            this.mLocalContentUriFetchSequence = this.newBitmapCacheGetToLocalTransformSequence(localContentUriFetchProducer);
        }
        return this.mLocalContentUriFetchSequence;
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getLocalResourceFetchSequence() {
        if (this.mLocalResourceFetchSequence == null) {
            LocalResourceFetchProducer localResourceFetchProducer = this.mProducerFactory.newLocalResourceFetchProducer();
            this.mLocalResourceFetchSequence = this.newBitmapCacheGetToLocalTransformSequence(localResourceFetchProducer);
        }
        return this.mLocalResourceFetchSequence;
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getLocalAssetFetchSequence() {
        if (this.mLocalAssetFetchSequence == null) {
            LocalAssetFetchProducer localAssetFetchProducer = this.mProducerFactory.newLocalAssetFetchProducer();
            this.mLocalAssetFetchSequence = this.newBitmapCacheGetToLocalTransformSequence(localAssetFetchProducer);
        }
        return this.mLocalAssetFetchSequence;
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getDataFetchSequence() {
        if (this.mDataFetchSequence == null) {
            Producer<EncodedImage> inputProducer = this.mProducerFactory.newDataFetchProducer();
            if (Build.VERSION.SDK_INT < 18 && !this.mWebpSupportEnabled) {
                inputProducer = this.mProducerFactory.newWebpTranscodeProducer(inputProducer);
            }
            inputProducer = ProducerFactory.newAddImageTransformMetaDataProducer(inputProducer);
            if (!this.mDownsampleEnabled) {
                inputProducer = this.mProducerFactory.newResizeAndRotateProducer(inputProducer);
            }
            this.mDataFetchSequence = this.newBitmapCacheGetToDecodeSequence(inputProducer);
        }
        return this.mDataFetchSequence;
    }

    private Producer<CloseableReference<CloseableImage>> newBitmapCacheGetToLocalTransformSequence(Producer<EncodedImage> inputProducer) {
        inputProducer = this.newEncodedCacheMultiplexToTranscodeSequence(inputProducer);
        Producer<EncodedImage> inputProducerAfterDecode = this.newLocalTransformationsSequence(inputProducer);
        return this.newBitmapCacheGetToDecodeSequence(inputProducerAfterDecode);
    }

    private Producer<CloseableReference<CloseableImage>> newBitmapCacheGetToDecodeSequence(Producer<EncodedImage> inputProducer) {
        DecodeProducer decodeProducer = this.mProducerFactory.newDecodeProducer(inputProducer);
        return this.newBitmapCacheGetToBitmapCacheSequence(decodeProducer);
    }

    private Producer<EncodedImage> newEncodedCacheMultiplexToTranscodeSequence(Producer<EncodedImage> inputProducer) {
        if (Build.VERSION.SDK_INT < 18 && !this.mWebpSupportEnabled) {
            inputProducer = this.mProducerFactory.newWebpTranscodeProducer(inputProducer);
        }
        inputProducer = this.mProducerFactory.newDiskCacheProducer(inputProducer);
        EncodedMemoryCacheProducer encodedMemoryCacheProducer = this.mProducerFactory.newEncodedMemoryCacheProducer(inputProducer);
        return this.mProducerFactory.newEncodedCacheKeyMultiplexProducer(encodedMemoryCacheProducer);
    }

    private Producer<CloseableReference<CloseableImage>> newBitmapCacheGetToBitmapCacheSequence(Producer<CloseableReference<CloseableImage>> inputProducer) {
        BitmapMemoryCacheProducer bitmapMemoryCacheProducer = this.mProducerFactory.newBitmapMemoryCacheProducer(inputProducer);
        BitmapMemoryCacheKeyMultiplexProducer bitmapKeyMultiplexProducer = this.mProducerFactory.newBitmapMemoryCacheKeyMultiplexProducer(bitmapMemoryCacheProducer);
        ThreadHandoffProducer<CloseableReference<CloseableImage>> threadHandoffProducer = this.mProducerFactory.newBackgroundThreadHandoffProducer(bitmapKeyMultiplexProducer, this.mThreadHandoffProducerQueue);
        return this.mProducerFactory.newBitmapMemoryCacheGetProducer(threadHandoffProducer);
    }

    private Producer<EncodedImage> newLocalTransformationsSequence(Producer<EncodedImage> inputProducer) {
        Producer<EncodedImage> localImageProducer = ProducerFactory.newAddImageTransformMetaDataProducer(inputProducer);
        if (!this.mDownsampleEnabled) {
            localImageProducer = this.mProducerFactory.newResizeAndRotateProducer(localImageProducer);
        }
        ThrottlingProducer<EncodedImage> localImageThrottlingProducer = this.mProducerFactory.newThrottlingProducer(5, localImageProducer);
        Producer<EncodedImage> localExifThumbnailProducer = this.mProducerFactory.newLocalExifThumbnailProducer();
        if (!this.mDownsampleEnabled) {
            localExifThumbnailProducer = this.mProducerFactory.newResizeAndRotateProducer(localExifThumbnailProducer);
        }
        return ProducerFactory.newBranchOnSeparateImagesProducer(localExifThumbnailProducer, localImageThrottlingProducer);
    }

    private synchronized Producer<CloseableReference<CloseableImage>> getPostprocessorSequence(Producer<CloseableReference<CloseableImage>> inputProducer) {
        if (!this.mPostprocessorSequences.containsKey(inputProducer)) {
            PostprocessorProducer postprocessorProducer = this.mProducerFactory.newPostprocessorProducer(inputProducer);
            PostprocessedBitmapMemoryCacheProducer postprocessedBitmapMemoryCacheProducer = this.mProducerFactory.newPostprocessorBitmapMemoryCacheProducer(postprocessorProducer);
            this.mPostprocessorSequences.put(inputProducer, postprocessedBitmapMemoryCacheProducer);
        }
        return this.mPostprocessorSequences.get(inputProducer);
    }

    private synchronized Producer<Void> getDecodedImagePrefetchSequence(Producer<CloseableReference<CloseableImage>> inputProducer) {
        if (!this.mCloseableImagePrefetchSequences.containsKey(inputProducer)) {
            SwallowResultProducer<CloseableReference<CloseableImage>> swallowResultProducer = ProducerFactory.newSwallowResultProducer(inputProducer);
            this.mCloseableImagePrefetchSequences.put(inputProducer, swallowResultProducer);
        }
        return this.mCloseableImagePrefetchSequences.get(inputProducer);
    }
}

