/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.logging.FLog;
import java.util.LinkedList;
import java.util.Queue;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
@VisibleForTesting
class Bucket<V> {
    private static final String TAG = "BUCKET";
    public final int mItemSize;
    public final int mMaxLength;
    final Queue mFreeList;
    private final boolean mFixBucketsReinitialization;
    private int mInUseLength;

    public Bucket(int itemSize, int maxLength, int inUseLength, boolean fixBucketsReinitialization) {
        Preconditions.checkState((itemSize > 0 ? 1 : 0) != 0);
        Preconditions.checkState((maxLength >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((inUseLength >= 0 ? 1 : 0) != 0);
        this.mItemSize = itemSize;
        this.mMaxLength = maxLength;
        this.mFreeList = new LinkedList();
        this.mInUseLength = inUseLength;
        this.mFixBucketsReinitialization = fixBucketsReinitialization;
    }

    public boolean isMaxLengthExceeded() {
        return this.mInUseLength + this.getFreeListSize() > this.mMaxLength;
    }

    int getFreeListSize() {
        return this.mFreeList.size();
    }

    @Nullable
    public V get() {
        V value = this.pop();
        if (value != null) {
            ++this.mInUseLength;
        }
        return value;
    }

    @Nullable
    public V pop() {
        return (V)this.mFreeList.poll();
    }

    public void incrementInUseCount() {
        ++this.mInUseLength;
    }

    public void release(V value) {
        Preconditions.checkNotNull(value);
        if (this.mFixBucketsReinitialization) {
            Preconditions.checkState((this.mInUseLength > 0 ? 1 : 0) != 0);
            --this.mInUseLength;
            this.addToFreeList(value);
        } else if (this.mInUseLength > 0) {
            --this.mInUseLength;
            this.addToFreeList(value);
        } else {
            FLog.e((String)TAG, (String)"Tried to release value %s from an empty bucket!", (Object[])new Object[]{value});
        }
    }

    void addToFreeList(V value) {
        this.mFreeList.add(value);
    }

    public void decrementInUseCount() {
        Preconditions.checkState((this.mInUseLength > 0 ? 1 : 0) != 0);
        --this.mInUseLength;
    }

    public int getInUseCount() {
        return this.mInUseLength;
    }
}

