/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.nativecode;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import com.facebook.common.internal.DoNotStrip;
import com.facebook.common.internal.Preconditions;
import com.facebook.imagepipeline.nativecode.ImagePipelineNativeLoader;
import com.facebook.imageutils.BitmapUtil;
import java.nio.ByteBuffer;

@DoNotStrip
public class Bitmaps {
    public static void pinBitmap(Bitmap bitmap) {
        Preconditions.checkNotNull((Object)bitmap);
        Bitmaps.nativePinBitmap(bitmap);
    }

    public static ByteBuffer getByteBuffer(Bitmap bitmap, long start, long size) {
        Preconditions.checkNotNull((Object)bitmap);
        return Bitmaps.nativeGetByteBuffer(bitmap, start, size);
    }

    public static void releaseByteBuffer(Bitmap bitmap) {
        Preconditions.checkNotNull((Object)bitmap);
        Bitmaps.nativeReleaseByteBuffer(bitmap);
    }

    public static void copyBitmap(Bitmap dest, Bitmap src) {
        Preconditions.checkArgument((src.getConfig() == dest.getConfig() ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)dest.isMutable());
        Preconditions.checkArgument((dest.getWidth() == src.getWidth() ? 1 : 0) != 0);
        Preconditions.checkArgument((dest.getHeight() == src.getHeight() ? 1 : 0) != 0);
        Bitmaps.nativeCopyBitmap(dest, dest.getRowBytes(), src, src.getRowBytes(), dest.getHeight());
    }

    @TargetApi(value=19)
    public static void reconfigureBitmap(Bitmap bitmap, int width, int height, Bitmap.Config bitmapConfig) {
        Preconditions.checkArgument((bitmap.getAllocationByteCount() >= width * height * BitmapUtil.getPixelSizeForBitmapConfig((Bitmap.Config)bitmapConfig) ? 1 : 0) != 0);
        bitmap.reconfigure(width, height, bitmapConfig);
    }

    @DoNotStrip
    private static native ByteBuffer nativeGetByteBuffer(Bitmap var0, long var1, long var3);

    @DoNotStrip
    private static native void nativePinBitmap(Bitmap var0);

    @DoNotStrip
    private static native void nativeReleaseByteBuffer(Bitmap var0);

    @DoNotStrip
    private static native void nativeCopyBitmap(Bitmap var0, int var1, Bitmap var2, int var3, int var4);

    static {
        ImagePipelineNativeLoader.load();
    }
}

