/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.filter;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.support.annotation.RequiresApi;
import com.facebook.common.internal.Preconditions;

public abstract class RenderScriptBlurFilter {
    public static final int BLUR_MAX_RADIUS = 25;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(value=17)
    public static void blurBitmap(Bitmap dest, Bitmap src, Context context, int radius) {
        Preconditions.checkNotNull((Object)dest);
        Preconditions.checkNotNull((Object)src);
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkArgument((radius > 0 && radius <= 25 ? 1 : 0) != 0);
        RenderScript rs = null;
        try {
            rs = RenderScript.create((Context)context);
            ScriptIntrinsicBlur blurScript = ScriptIntrinsicBlur.create((RenderScript)rs, (Element)Element.U8_4((RenderScript)rs));
            Allocation allIn = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)src);
            Allocation allOut = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)dest);
            blurScript.setRadius((float)radius);
            blurScript.setInput(allIn);
            blurScript.forEach(allOut);
            allOut.copyTo(dest);
        }
        finally {
            if (rs != null) {
                rs.destroy();
            }
        }
    }

    public static boolean canUseRenderScript() {
        return Build.VERSION.SDK_INT >= 17;
    }
}

