/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.core;

import com.facebook.common.logging.FLog;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.common.references.SharedReference;
import com.facebook.imagepipeline.debug.CloseableReferenceLeakTracker;
import java.io.Closeable;

public class CloseableReferenceFactory {
    private final CloseableReference.LeakHandler<Closeable> mLeakHandler;

    public CloseableReferenceFactory(final CloseableReferenceLeakTracker closeableReferenceLeakTracker) {
        this.mLeakHandler = new CloseableReference.LeakHandler<Closeable>(){

            public void reportLeak(SharedReference<Closeable> reference) {
                closeableReferenceLeakTracker.trackCloseableReferenceLeak(reference);
                FLog.w((String)"Fresco", (String)"Finalized without closing: %x %x (type = %s)", (Object[])new Object[]{System.identityHashCode(this), System.identityHashCode(reference), ((Closeable)reference.get()).getClass().getName()});
            }
        };
    }

    public <U extends Closeable> CloseableReference<U> create(U u) {
        return CloseableReference.of(u, this.mLeakHandler);
    }

    public <T> CloseableReference<T> create(T t, ResourceReleaser<T> resourceReleaser) {
        return CloseableReference.of(t, resourceReleaser, this.mLeakHandler);
    }
}

