/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import com.facebook.common.references.OOMSoftReference;
import com.facebook.imagepipeline.memory.Bucket;
import java.util.LinkedList;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class OOMSoftReferenceBucket<V>
extends Bucket<V> {
    private LinkedList<OOMSoftReference<V>> mSpareReferences = new LinkedList();

    public OOMSoftReferenceBucket(int itemSize, int maxLength, int inUseLength) {
        super(itemSize, maxLength, inUseLength, false);
    }

    @Override
    public V pop() {
        OOMSoftReference ref = (OOMSoftReference)this.mFreeList.poll();
        Object value = ref.get();
        ref.clear();
        this.mSpareReferences.add(ref);
        return (V)value;
    }

    @Override
    void addToFreeList(V value) {
        OOMSoftReference ref = this.mSpareReferences.poll();
        if (ref == null) {
            ref = new OOMSoftReference();
        }
        ref.set(value);
        this.mFreeList.add(ref);
    }
}

