/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.cache;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.net.Uri;
import android.provider.BaseColumns;
import android.text.TextUtils;
import bolts.Task;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.common.CacheKeyUtil;
import com.facebook.common.internal.VisibleForTesting;
import com.facebook.common.logging.FLog;
import com.facebook.imagepipeline.cache.MediaVariationsIndex;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.MediaVariations;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class MediaVariationsIndexDatabase
implements MediaVariationsIndex {
    private static final String TAG = MediaVariationsIndexDatabase.class.getSimpleName();
    private static final String[] PROJECTION = new String[]{"cache_choice", "cache_key", "width", "height"};
    private static final String SQL_DELETE_ENTRIES = "DROP TABLE IF EXISTS media_variations_index";
    @GuardedBy(value="MediaVariationsIndexDatabase.class")
    private final LazyIndexDbOpenHelper mDbHelper;
    private final Executor mReadExecutor;
    private final Executor mWriteExecutor;

    public MediaVariationsIndexDatabase(Context context, Executor readExecutor, Executor writeExecutor) {
        this.mDbHelper = new LazyIndexDbOpenHelper(context);
        this.mReadExecutor = readExecutor;
        this.mWriteExecutor = writeExecutor;
    }

    @Override
    public Task<MediaVariations> getCachedVariants(final String mediaId, final MediaVariations.Builder mediaVariationsBuilder) {
        try {
            return Task.call((Callable)new Callable<MediaVariations>(){

                @Override
                public MediaVariations call() throws Exception {
                    return MediaVariationsIndexDatabase.this.getCachedVariantsSync(mediaId, mediaVariationsBuilder);
                }
            }, (Executor)this.mReadExecutor);
        }
        catch (Exception exception) {
            FLog.w((String)TAG, (Throwable)exception, (String)"Failed to schedule query task for %s", (Object[])new Object[]{mediaId});
            return Task.forError((Exception)exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    protected MediaVariations getCachedVariantsSync(String mediaId, MediaVariations.Builder mediaVariationsBuilder) {
        Class<MediaVariationsIndexDatabase> clazz = MediaVariationsIndexDatabase.class;
        synchronized (MediaVariationsIndexDatabase.class) {
            SQLiteDatabase db = this.mDbHelper.getWritableDatabase();
            try (Cursor c = null;){
                String selection = "media_id = ?";
                String[] selectionArgs = new String[]{mediaId};
                c = db.query("media_variations_index", PROJECTION, selection, selectionArgs, null, null, null);
                if (c.getCount() == 0) {
                    MediaVariations mediaVariations = mediaVariationsBuilder.build();
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return mediaVariations;
                }
                int columnIndexCacheKey = c.getColumnIndexOrThrow("cache_key");
                int columnIndexWidth = c.getColumnIndexOrThrow("width");
                int columnIndexHeight = c.getColumnIndexOrThrow("height");
                int columnIndexCacheChoice = c.getColumnIndexOrThrow("cache_choice");
                while (c.moveToNext()) {
                    String cacheChoiceStr = c.getString(columnIndexCacheChoice);
                    mediaVariationsBuilder.addVariant(Uri.parse((String)c.getString(columnIndexCacheKey)), c.getInt(columnIndexWidth), c.getInt(columnIndexHeight), TextUtils.isEmpty((CharSequence)cacheChoiceStr) ? null : ImageRequest.CacheChoice.valueOf(cacheChoiceStr));
                }
                MediaVariations mediaVariations = mediaVariationsBuilder.build();
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return mediaVariations;
            }
        }
    }

    @Override
    public void saveCachedVariant(final String mediaId, final ImageRequest.CacheChoice cacheChoice, final CacheKey cacheKey, final EncodedImage encodedImage) {
        this.mWriteExecutor.execute(new Runnable(){

            @Override
            public void run() {
                MediaVariationsIndexDatabase.this.saveCachedVariantSync(mediaId, cacheChoice, cacheKey, encodedImage);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveCachedVariantSync(String mediaId, ImageRequest.CacheChoice cacheChoice, CacheKey cacheKey, EncodedImage encodedImage) {
        Class<MediaVariationsIndexDatabase> clazz = MediaVariationsIndexDatabase.class;
        synchronized (MediaVariationsIndexDatabase.class) {
            SQLiteDatabase db = this.mDbHelper.getWritableDatabase();
            try {
                db.beginTransaction();
                ContentValues contentValues = new ContentValues();
                contentValues.put("media_id", mediaId);
                contentValues.put("width", Integer.valueOf(encodedImage.getWidth()));
                contentValues.put("height", Integer.valueOf(encodedImage.getHeight()));
                contentValues.put("cache_choice", cacheChoice.name());
                contentValues.put("cache_key", cacheKey.getUriString());
                contentValues.put("resource_id", CacheKeyUtil.getFirstResourceId((CacheKey)cacheKey));
                db.replaceOrThrow("media_variations_index", null, contentValues);
                db.setTransactionSuccessful();
            }
            catch (Exception x) {
                FLog.e((String)TAG, (Throwable)x, (String)"Error writing for %s", (Object[])new Object[]{mediaId});
            }
            finally {
                try {
                    db.endTransaction();
                }
                catch (SQLiteException sQLiteException) {}
            }
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return;
        }
    }

    private static class IndexDbOpenHelper
    extends SQLiteOpenHelper {
        public static final int DATABASE_VERSION = 2;
        public static final String DATABASE_NAME = "FrescoMediaVariationsIndex.db";
        private static final String TEXT_TYPE = " TEXT";
        private static final String INTEGER_TYPE = " INTEGER";
        private static final String SQL_CREATE_ENTRIES = "CREATE TABLE media_variations_index (_id INTEGER PRIMARY KEY,media_id TEXT,width INTEGER,height INTEGER,cache_choice TEXT,cache_key TEXT,resource_id TEXT UNIQUE )";
        private static final String SQL_CREATE_INDEX = "CREATE INDEX index_media_id ON media_variations_index (media_id)";

        public IndexDbOpenHelper(Context context) {
            super(context, DATABASE_NAME, null, 2);
        }

        public void onCreate(SQLiteDatabase db) {
            db.beginTransaction();
            try {
                db.execSQL(SQL_CREATE_ENTRIES);
                db.execSQL(SQL_CREATE_INDEX);
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            db.beginTransaction();
            try {
                db.execSQL(MediaVariationsIndexDatabase.SQL_DELETE_ENTRIES);
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
            this.onCreate(db);
        }

        public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            this.onUpgrade(db, oldVersion, newVersion);
        }
    }

    private static class LazyIndexDbOpenHelper {
        private final Context mContext;
        @Nullable
        private IndexDbOpenHelper mIndexDbOpenHelper;

        private LazyIndexDbOpenHelper(Context context) {
            this.mContext = context;
        }

        public synchronized SQLiteDatabase getWritableDatabase() {
            if (this.mIndexDbOpenHelper == null) {
                this.mIndexDbOpenHelper = new IndexDbOpenHelper(this.mContext);
            }
            return this.mIndexDbOpenHelper.getWritableDatabase();
        }
    }

    private static final class IndexEntry
    implements BaseColumns {
        public static final String TABLE_NAME = "media_variations_index";
        public static final String COLUMN_NAME_MEDIA_ID = "media_id";
        public static final String COLUMN_NAME_WIDTH = "width";
        public static final String COLUMN_NAME_HEIGHT = "height";
        public static final String COLUMN_NAME_CACHE_CHOICE = "cache_choice";
        public static final String COLUMN_NAME_CACHE_KEY = "cache_key";
        public static final String COLUMN_NAME_RESOURCE_ID = "resource_id";

        private IndexEntry() {
        }
    }
}

