/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.platform;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import androidx.core.util.Pools;
import com.facebook.imagepipeline.memory.BitmapPool;
import com.facebook.imagepipeline.platform.DefaultDecoder;
import com.facebook.imageutils.BitmapUtil;
import javax.annotation.concurrent.ThreadSafe;

@TargetApi(value=26)
@ThreadSafe
public class OreoDecoder
extends DefaultDecoder {
    public OreoDecoder(BitmapPool bitmapPool, int maxNumThreads, Pools.SynchronizedPool decodeBuffers) {
        super(bitmapPool, maxNumThreads, decodeBuffers);
    }

    @Override
    public int getBitmapSize(int width, int height, BitmapFactory.Options options) {
        return OreoDecoder.hasColorGamutMismatch(options) ? width * height * 8 : BitmapUtil.getSizeInByteForBitmap((int)width, (int)height, (Bitmap.Config)options.inPreferredConfig);
    }

    private static boolean hasColorGamutMismatch(BitmapFactory.Options options) {
        return options.outColorSpace != null && options.outColorSpace.isWideGamut() && options.inPreferredConfig != Bitmap.Config.RGBA_F16;
    }
}

