/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.platform;

import android.os.Build;
import androidx.core.util.Pools;
import com.facebook.imagepipeline.core.NativeCodeSetup;
import com.facebook.imagepipeline.memory.FlexByteArrayPool;
import com.facebook.imagepipeline.memory.PoolFactory;
import com.facebook.imagepipeline.platform.ArtDecoder;
import com.facebook.imagepipeline.platform.OreoDecoder;
import com.facebook.imagepipeline.platform.PlatformDecoder;
import java.lang.reflect.InvocationTargetException;

public class PlatformDecoderFactory {
    public static PlatformDecoder buildPlatformDecoder(PoolFactory poolFactory, boolean gingerbreadDecoderEnabled) {
        if (Build.VERSION.SDK_INT >= 26) {
            int maxNumThreads = poolFactory.getFlexByteArrayPoolMaxNumThreads();
            return new OreoDecoder(poolFactory.getBitmapPool(), maxNumThreads, new Pools.SynchronizedPool(maxNumThreads));
        }
        if (Build.VERSION.SDK_INT >= 21 || !NativeCodeSetup.getUseNativeCode()) {
            int maxNumThreads = poolFactory.getFlexByteArrayPoolMaxNumThreads();
            return new ArtDecoder(poolFactory.getBitmapPool(), maxNumThreads, new Pools.SynchronizedPool(maxNumThreads));
        }
        try {
            if (gingerbreadDecoderEnabled && Build.VERSION.SDK_INT < 19) {
                Class<?> clazz = Class.forName("com.facebook.imagepipeline.platform.GingerbreadPurgeableDecoder");
                return (PlatformDecoder)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            Class<?> clazz = Class.forName("com.facebook.imagepipeline.platform.KitKatPurgeableDecoder");
            return (PlatformDecoder)clazz.getConstructor(FlexByteArrayPool.class).newInstance(poolFactory.getFlexByteArrayPool());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Wrong Native code setup, reflection failed.", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Wrong Native code setup, reflection failed.", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Wrong Native code setup, reflection failed.", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Wrong Native code setup, reflection failed.", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Wrong Native code setup, reflection failed.", e);
        }
    }
}

