/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.common.internal.Preconditions;
import com.facebook.imagepipeline.producers.ThreadHandoffProducerQueue;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.Executor;

public class ThreadHandoffProducerQueueImpl
implements ThreadHandoffProducerQueue {
    private boolean mQueueing = false;
    private final Deque<Runnable> mRunnableList;
    private final Executor mExecutor;

    public ThreadHandoffProducerQueueImpl(Executor executor) {
        this.mExecutor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.mRunnableList = new ArrayDeque<Runnable>();
    }

    @Override
    public synchronized void addToQueueOrExecute(Runnable runnable) {
        if (this.mQueueing) {
            this.mRunnableList.add(runnable);
        } else {
            this.mExecutor.execute(runnable);
        }
    }

    @Override
    public synchronized void startQueueing() {
        this.mQueueing = true;
    }

    @Override
    public synchronized void stopQueuing() {
        this.mQueueing = false;
        this.execInQueue();
    }

    private void execInQueue() {
        while (!this.mRunnableList.isEmpty()) {
            this.mExecutor.execute(this.mRunnableList.pop());
        }
        this.mRunnableList.clear();
    }

    @Override
    public synchronized void remove(Runnable runnable) {
        this.mRunnableList.remove(runnable);
    }

    @Override
    public synchronized boolean isQueueing() {
        return this.mQueueing;
    }
}

