/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.bitmaps;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.memory.PooledByteBuffer;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.webp.BitmapCreator;
import com.facebook.imageformat.DefaultImageFormats;
import com.facebook.imagepipeline.bitmaps.EmptyJpegGenerator;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.memory.FlexByteArrayPool;
import com.facebook.imagepipeline.memory.PoolFactory;
import com.facebook.infer.annotation.Nullsafe;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class HoneycombBitmapCreator
implements BitmapCreator {
    private final EmptyJpegGenerator mJpegGenerator;
    private final FlexByteArrayPool mFlexByteArrayPool;

    public HoneycombBitmapCreator(PoolFactory poolFactory) {
        this.mFlexByteArrayPool = poolFactory.getFlexByteArrayPool();
        this.mJpegGenerator = new EmptyJpegGenerator(poolFactory.getPooledByteBufferFactory());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=12)
    public Bitmap createNakedBitmap(int width, int height, Bitmap.Config bitmapConfig) {
        CloseableReference<PooledByteBuffer> jpgRef = this.mJpegGenerator.generate((short)width, (short)height);
        EncodedImage encodedImage = null;
        CloseableReference<byte[]> encodedBytesArrayRef = null;
        try {
            encodedImage = new EncodedImage(jpgRef);
            encodedImage.setImageFormat(DefaultImageFormats.JPEG);
            BitmapFactory.Options options = HoneycombBitmapCreator.getBitmapFactoryOptions(encodedImage.getSampleSize(), bitmapConfig);
            int length = ((PooledByteBuffer)jpgRef.get()).size();
            PooledByteBuffer pooledByteBuffer = (PooledByteBuffer)jpgRef.get();
            encodedBytesArrayRef = this.mFlexByteArrayPool.get(length + 2);
            byte[] encodedBytesArray = (byte[])encodedBytesArrayRef.get();
            pooledByteBuffer.read(0, encodedBytesArray, 0, length);
            Bitmap bitmap = (Bitmap)Preconditions.checkNotNull((Object)BitmapFactory.decodeByteArray((byte[])encodedBytesArray, (int)0, (int)length, (BitmapFactory.Options)options));
            bitmap.setHasAlpha(true);
            bitmap.eraseColor(0);
            Bitmap bitmap2 = bitmap;
            return bitmap2;
        }
        finally {
            CloseableReference.closeSafely(encodedBytesArrayRef);
            EncodedImage.closeSafely((EncodedImage)encodedImage);
            CloseableReference.closeSafely(jpgRef);
        }
    }

    private static BitmapFactory.Options getBitmapFactoryOptions(int sampleSize, Bitmap.Config bitmapConfig) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inDither = true;
        options.inPreferredConfig = bitmapConfig;
        options.inPurgeable = true;
        options.inInputShareable = true;
        options.inSampleSize = sampleSize;
        if (Build.VERSION.SDK_INT >= 11) {
            options.inMutable = true;
        }
        return options;
    }
}

