/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.core;

import android.net.Uri;
import bolts.Continuation;
import bolts.Task;
import com.facebook.cache.common.CacheKey;
import com.facebook.callercontext.CallerContextVerifier;
import com.facebook.common.internal.Objects;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.internal.Predicate;
import com.facebook.common.internal.Supplier;
import com.facebook.common.memory.PooledByteBuffer;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.util.UriUtil;
import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSources;
import com.facebook.datasource.SimpleDataSource;
import com.facebook.imagepipeline.cache.BufferedDiskCache;
import com.facebook.imagepipeline.cache.CacheKeyFactory;
import com.facebook.imagepipeline.cache.MemoryCache;
import com.facebook.imagepipeline.common.Priority;
import com.facebook.imagepipeline.core.ImagePipelineConfigInterface;
import com.facebook.imagepipeline.core.ProducerSequenceFactory;
import com.facebook.imagepipeline.datasource.CloseableProducerToDataSourceAdapter;
import com.facebook.imagepipeline.datasource.ProducerToDataSourceAdapter;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.listener.ForwardingRequestListener;
import com.facebook.imagepipeline.listener.ForwardingRequestListener2;
import com.facebook.imagepipeline.listener.RequestListener;
import com.facebook.imagepipeline.listener.RequestListener2;
import com.facebook.imagepipeline.producers.InternalRequestListener;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.SettableProducerContext;
import com.facebook.imagepipeline.producers.ThreadHandoffProducerQueue;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.facebook.imagepipeline.systrace.FrescoSystrace;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ImagePipeline {
    private static final CancellationException PREFETCH_EXCEPTION = new CancellationException("Prefetching is not enabled");
    private final ProducerSequenceFactory mProducerSequenceFactory;
    private final RequestListener mRequestListener;
    private final RequestListener2 mRequestListener2;
    private final Supplier<Boolean> mIsPrefetchEnabledSupplier;
    private final MemoryCache<CacheKey, CloseableImage> mBitmapMemoryCache;
    private final MemoryCache<CacheKey, PooledByteBuffer> mEncodedMemoryCache;
    private final BufferedDiskCache mMainBufferedDiskCache;
    private final BufferedDiskCache mSmallImageBufferedDiskCache;
    private final CacheKeyFactory mCacheKeyFactory;
    private final ThreadHandoffProducerQueue mThreadHandoffProducerQueue;
    private final Supplier<Boolean> mSuppressBitmapPrefetchingSupplier;
    private AtomicLong mIdCounter = new AtomicLong();
    private final Supplier<Boolean> mLazyDataSource;
    @Nullable
    private final CallerContextVerifier mCallerContextVerifier;
    private final ImagePipelineConfigInterface mConfig;

    public ImagePipeline(ProducerSequenceFactory producerSequenceFactory, Set<RequestListener> requestListeners, Set<RequestListener2> requestListener2s, Supplier<Boolean> isPrefetchEnabledSupplier, MemoryCache<CacheKey, CloseableImage> bitmapMemoryCache, MemoryCache<CacheKey, PooledByteBuffer> encodedMemoryCache, BufferedDiskCache mainBufferedDiskCache, BufferedDiskCache smallImageBufferedDiskCache, CacheKeyFactory cacheKeyFactory, ThreadHandoffProducerQueue threadHandoffProducerQueue, Supplier<Boolean> suppressBitmapPrefetchingSupplier, Supplier<Boolean> lazyDataSource, @Nullable CallerContextVerifier callerContextVerifier, ImagePipelineConfigInterface config) {
        this.mProducerSequenceFactory = producerSequenceFactory;
        this.mRequestListener = new ForwardingRequestListener(requestListeners);
        this.mRequestListener2 = new ForwardingRequestListener2(requestListener2s);
        this.mIsPrefetchEnabledSupplier = isPrefetchEnabledSupplier;
        this.mBitmapMemoryCache = bitmapMemoryCache;
        this.mEncodedMemoryCache = encodedMemoryCache;
        this.mMainBufferedDiskCache = mainBufferedDiskCache;
        this.mSmallImageBufferedDiskCache = smallImageBufferedDiskCache;
        this.mCacheKeyFactory = cacheKeyFactory;
        this.mThreadHandoffProducerQueue = threadHandoffProducerQueue;
        this.mSuppressBitmapPrefetchingSupplier = suppressBitmapPrefetchingSupplier;
        this.mLazyDataSource = lazyDataSource;
        this.mCallerContextVerifier = callerContextVerifier;
        this.mConfig = config;
    }

    public String generateUniqueFutureId() {
        return String.valueOf(this.mIdCounter.getAndIncrement());
    }

    public Supplier<DataSource<CloseableReference<CloseableImage>>> getDataSourceSupplier(final ImageRequest imageRequest, final Object callerContext, final ImageRequest.RequestLevel requestLevel) {
        return new Supplier<DataSource<CloseableReference<CloseableImage>>>(){

            public DataSource<CloseableReference<CloseableImage>> get() {
                return ImagePipeline.this.fetchDecodedImage(imageRequest, callerContext, requestLevel);
            }

            public String toString() {
                return Objects.toStringHelper((Object)this).add("uri", (Object)imageRequest.getSourceUri()).toString();
            }
        };
    }

    public Supplier<DataSource<CloseableReference<CloseableImage>>> getDataSourceSupplier(final ImageRequest imageRequest, final Object callerContext, final ImageRequest.RequestLevel requestLevel, final @Nullable RequestListener requestListener) {
        return new Supplier<DataSource<CloseableReference<CloseableImage>>>(){

            public DataSource<CloseableReference<CloseableImage>> get() {
                return ImagePipeline.this.fetchDecodedImage(imageRequest, callerContext, requestLevel, requestListener);
            }

            public String toString() {
                return Objects.toStringHelper((Object)this).add("uri", (Object)imageRequest.getSourceUri()).toString();
            }
        };
    }

    public Supplier<DataSource<CloseableReference<CloseableImage>>> getDataSourceSupplier(final ImageRequest imageRequest, final Object callerContext, final ImageRequest.RequestLevel requestLevel, final @Nullable RequestListener requestListener, final @Nullable String uiComponentId) {
        return new Supplier<DataSource<CloseableReference<CloseableImage>>>(){

            public DataSource<CloseableReference<CloseableImage>> get() {
                return ImagePipeline.this.fetchDecodedImage(imageRequest, callerContext, requestLevel, requestListener, uiComponentId);
            }

            public String toString() {
                return Objects.toStringHelper((Object)this).add("uri", (Object)imageRequest.getSourceUri()).toString();
            }
        };
    }

    public Supplier<DataSource<CloseableReference<PooledByteBuffer>>> getEncodedImageDataSourceSupplier(final ImageRequest imageRequest, final Object callerContext) {
        return new Supplier<DataSource<CloseableReference<PooledByteBuffer>>>(){

            public DataSource<CloseableReference<PooledByteBuffer>> get() {
                return ImagePipeline.this.fetchEncodedImage(imageRequest, callerContext);
            }

            public String toString() {
                return Objects.toStringHelper((Object)this).add("uri", (Object)imageRequest.getSourceUri()).toString();
            }
        };
    }

    public DataSource<CloseableReference<CloseableImage>> fetchImageFromBitmapCache(ImageRequest imageRequest, Object callerContext) {
        return this.fetchDecodedImage(imageRequest, callerContext, ImageRequest.RequestLevel.BITMAP_MEMORY_CACHE);
    }

    public DataSource<CloseableReference<CloseableImage>> fetchDecodedImage(ImageRequest imageRequest, Object callerContext) {
        return this.fetchDecodedImage(imageRequest, callerContext, ImageRequest.RequestLevel.FULL_FETCH);
    }

    public DataSource<CloseableReference<CloseableImage>> fetchDecodedImage(ImageRequest imageRequest, Object callerContext, @Nullable RequestListener requestListener) {
        return this.fetchDecodedImage(imageRequest, callerContext, ImageRequest.RequestLevel.FULL_FETCH, requestListener);
    }

    public DataSource<CloseableReference<CloseableImage>> fetchDecodedImage(ImageRequest imageRequest, Object callerContext, ImageRequest.RequestLevel lowestPermittedRequestLevelOnSubmit) {
        return this.fetchDecodedImage(imageRequest, callerContext, lowestPermittedRequestLevelOnSubmit, null);
    }

    public DataSource<CloseableReference<CloseableImage>> fetchDecodedImage(ImageRequest imageRequest, Object callerContext, ImageRequest.RequestLevel lowestPermittedRequestLevelOnSubmit, @Nullable RequestListener requestListener) {
        return this.fetchDecodedImage(imageRequest, callerContext, lowestPermittedRequestLevelOnSubmit, requestListener, null);
    }

    public DataSource<CloseableReference<CloseableImage>> fetchDecodedImage(ImageRequest imageRequest, Object callerContext, ImageRequest.RequestLevel lowestPermittedRequestLevelOnSubmit, @Nullable RequestListener requestListener, @Nullable String uiComponentId) {
        try {
            Producer producerSequence = this.mProducerSequenceFactory.getDecodedImageProducerSequence(imageRequest);
            return this.submitFetchRequest(producerSequence, imageRequest, lowestPermittedRequestLevelOnSubmit, callerContext, requestListener, uiComponentId);
        }
        catch (Exception exception) {
            return DataSources.immediateFailedDataSource((Throwable)exception);
        }
    }

    public DataSource<CloseableReference<PooledByteBuffer>> fetchEncodedImage(ImageRequest imageRequest, Object callerContext) {
        return this.fetchEncodedImage(imageRequest, callerContext, null);
    }

    public DataSource<CloseableReference<PooledByteBuffer>> fetchEncodedImage(ImageRequest imageRequest, Object callerContext, @Nullable RequestListener requestListener) {
        Preconditions.checkNotNull((Object)imageRequest.getSourceUri());
        try {
            Producer producerSequence = this.mProducerSequenceFactory.getEncodedImageProducerSequence(imageRequest);
            if (imageRequest.getResizeOptions() != null) {
                imageRequest = ImageRequestBuilder.fromRequest(imageRequest).setResizeOptions(null).build();
            }
            return this.submitFetchRequest(producerSequence, imageRequest, ImageRequest.RequestLevel.FULL_FETCH, callerContext, requestListener, null);
        }
        catch (Exception exception) {
            return DataSources.immediateFailedDataSource((Throwable)exception);
        }
    }

    public DataSource<Void> prefetchToBitmapCache(ImageRequest imageRequest, Object callerContext) {
        return this.prefetchToBitmapCache(imageRequest, callerContext, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource<Void> prefetchToBitmapCache(ImageRequest imageRequest, Object callerContext, @Nullable RequestListener requestListener) {
        try {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.beginSection((String)"ImagePipeline#prefetchToBitmapCache");
            }
            if (!((Boolean)this.mIsPrefetchEnabledSupplier.get()).booleanValue()) {
                DataSource dataSource = DataSources.immediateFailedDataSource((Throwable)PREFETCH_EXCEPTION);
                return dataSource;
            }
            Boolean shouldDecodePrefetches = imageRequest.shouldDecodePrefetches();
            boolean skipBitmapCache = shouldDecodePrefetches != null ? !shouldDecodePrefetches.booleanValue() : (Boolean)this.mSuppressBitmapPrefetchingSupplier.get();
            Producer<Void> producerSequence = skipBitmapCache ? this.mProducerSequenceFactory.getEncodedImagePrefetchProducerSequence(imageRequest) : this.mProducerSequenceFactory.getDecodedImagePrefetchProducerSequence(imageRequest);
            DataSource<Void> dataSource = this.submitPrefetchRequest(producerSequence, imageRequest, ImageRequest.RequestLevel.FULL_FETCH, callerContext, Priority.MEDIUM, requestListener);
            return dataSource;
        }
        finally {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
        }
    }

    public DataSource<Void> prefetchToDiskCache(ImageRequest imageRequest, Object callerContext) {
        return this.prefetchToDiskCache(imageRequest, callerContext, Priority.MEDIUM);
    }

    public DataSource<Void> prefetchToDiskCache(ImageRequest imageRequest, Object callerContext, @Nullable RequestListener requestListener) {
        return this.prefetchToDiskCache(imageRequest, callerContext, Priority.MEDIUM, requestListener);
    }

    public DataSource<Void> prefetchToDiskCache(ImageRequest imageRequest, Object callerContext, Priority priority) {
        return this.prefetchToDiskCache(imageRequest, callerContext, priority, null);
    }

    public DataSource<Void> prefetchToDiskCache(ImageRequest imageRequest, Object callerContext, Priority priority, @Nullable RequestListener requestListener) {
        if (!((Boolean)this.mIsPrefetchEnabledSupplier.get()).booleanValue()) {
            return DataSources.immediateFailedDataSource((Throwable)PREFETCH_EXCEPTION);
        }
        try {
            Producer<Void> producerSequence = this.mProducerSequenceFactory.getEncodedImagePrefetchProducerSequence(imageRequest);
            return this.submitPrefetchRequest(producerSequence, imageRequest, ImageRequest.RequestLevel.FULL_FETCH, callerContext, priority, requestListener);
        }
        catch (Exception exception) {
            return DataSources.immediateFailedDataSource((Throwable)exception);
        }
    }

    public DataSource<Void> prefetchToEncodedCache(ImageRequest imageRequest, Object callerContext) {
        return this.prefetchToEncodedCache(imageRequest, callerContext, Priority.MEDIUM);
    }

    public DataSource<Void> prefetchToEncodedCache(ImageRequest imageRequest, Object callerContext, @Nullable RequestListener requestListener) {
        return this.prefetchToEncodedCache(imageRequest, callerContext, Priority.MEDIUM, requestListener);
    }

    public DataSource<Void> prefetchToEncodedCache(ImageRequest imageRequest, Object callerContext, Priority priority) {
        return this.prefetchToEncodedCache(imageRequest, callerContext, priority, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSource<Void> prefetchToEncodedCache(ImageRequest imageRequest, Object callerContext, Priority priority, @Nullable RequestListener requestListener) {
        try {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.beginSection((String)"ImagePipeline#prefetchToEncodedCache");
            }
            if (!((Boolean)this.mIsPrefetchEnabledSupplier.get()).booleanValue()) {
                DataSource dataSource = DataSources.immediateFailedDataSource((Throwable)PREFETCH_EXCEPTION);
                return dataSource;
            }
            Producer<Void> producerSequence = this.mProducerSequenceFactory.getEncodedImagePrefetchProducerSequence(imageRequest);
            DataSource<Void> dataSource = this.submitPrefetchRequest(producerSequence, imageRequest, ImageRequest.RequestLevel.FULL_FETCH, callerContext, priority, requestListener);
            return dataSource;
        }
        finally {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
        }
    }

    public void evictFromMemoryCache(Uri uri) {
        Predicate<CacheKey> predicate = this.predicateForUri(uri);
        this.mBitmapMemoryCache.removeAll(predicate);
        this.mEncodedMemoryCache.removeAll(predicate);
    }

    public void evictFromDiskCache(Uri uri) {
        this.evictFromDiskCache(ImageRequest.fromUri(uri));
    }

    public void evictFromDiskCache(ImageRequest imageRequest) {
        CacheKey cacheKey = this.mCacheKeyFactory.getEncodedCacheKey(imageRequest, null);
        this.mMainBufferedDiskCache.remove(cacheKey);
        this.mSmallImageBufferedDiskCache.remove(cacheKey);
    }

    public void evictFromCache(Uri uri) {
        this.evictFromMemoryCache(uri);
        this.evictFromDiskCache(uri);
    }

    public void clearMemoryCaches() {
        Predicate<CacheKey> allPredicate = new Predicate<CacheKey>(){

            public boolean apply(CacheKey key) {
                return true;
            }
        };
        this.mBitmapMemoryCache.removeAll((Predicate)allPredicate);
        this.mEncodedMemoryCache.removeAll((Predicate)allPredicate);
    }

    public void clearDiskCaches() {
        this.mMainBufferedDiskCache.clearAll();
        this.mSmallImageBufferedDiskCache.clearAll();
    }

    public long getUsedDiskCacheSize() {
        return this.mMainBufferedDiskCache.getSize() + this.mSmallImageBufferedDiskCache.getSize();
    }

    public void clearCaches() {
        this.clearMemoryCaches();
        this.clearDiskCaches();
    }

    public boolean isInBitmapMemoryCache(Uri uri) {
        if (uri == null) {
            return false;
        }
        Predicate<CacheKey> bitmapCachePredicate = this.predicateForUri(uri);
        return this.mBitmapMemoryCache.contains(bitmapCachePredicate);
    }

    public MemoryCache<CacheKey, CloseableImage> getBitmapMemoryCache() {
        return this.mBitmapMemoryCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInBitmapMemoryCache(ImageRequest imageRequest) {
        if (imageRequest == null) {
            return false;
        }
        CacheKey cacheKey = this.mCacheKeyFactory.getBitmapCacheKey(imageRequest, null);
        CloseableReference ref = this.mBitmapMemoryCache.get((Object)cacheKey);
        try {
            boolean bl = CloseableReference.isValid((CloseableReference)ref);
            return bl;
        }
        finally {
            CloseableReference.closeSafely((CloseableReference)ref);
        }
    }

    public boolean isInEncodedMemoryCache(Uri uri) {
        if (uri == null) {
            return false;
        }
        Predicate<CacheKey> encodedCachePredicate = this.predicateForUri(uri);
        return this.mEncodedMemoryCache.contains(encodedCachePredicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInEncodedMemoryCache(ImageRequest imageRequest) {
        if (imageRequest == null) {
            return false;
        }
        CacheKey cacheKey = this.mCacheKeyFactory.getEncodedCacheKey(imageRequest, null);
        CloseableReference ref = this.mEncodedMemoryCache.get((Object)cacheKey);
        try {
            boolean bl = CloseableReference.isValid((CloseableReference)ref);
            return bl;
        }
        finally {
            CloseableReference.closeSafely((CloseableReference)ref);
        }
    }

    public boolean isInDiskCacheSync(Uri uri) {
        return this.isInDiskCacheSync(uri, ImageRequest.CacheChoice.SMALL) || this.isInDiskCacheSync(uri, ImageRequest.CacheChoice.DEFAULT);
    }

    public boolean isInDiskCacheSync(Uri uri, ImageRequest.CacheChoice cacheChoice) {
        ImageRequest imageRequest = ImageRequestBuilder.newBuilderWithSource(uri).setCacheChoice(cacheChoice).build();
        return this.isInDiskCacheSync(imageRequest);
    }

    public boolean isInDiskCacheSync(ImageRequest imageRequest) {
        CacheKey cacheKey = this.mCacheKeyFactory.getEncodedCacheKey(imageRequest, null);
        ImageRequest.CacheChoice cacheChoice = imageRequest.getCacheChoice();
        switch (cacheChoice) {
            case DEFAULT: {
                return this.mMainBufferedDiskCache.diskCheckSync(cacheKey);
            }
            case SMALL: {
                return this.mSmallImageBufferedDiskCache.diskCheckSync(cacheKey);
            }
        }
        return false;
    }

    public DataSource<Boolean> isInDiskCache(Uri uri) {
        return this.isInDiskCache(ImageRequest.fromUri(uri));
    }

    public DataSource<Boolean> isInDiskCache(ImageRequest imageRequest) {
        final CacheKey cacheKey = this.mCacheKeyFactory.getEncodedCacheKey(imageRequest, null);
        final SimpleDataSource dataSource = SimpleDataSource.create();
        this.mMainBufferedDiskCache.contains(cacheKey).continueWithTask((Continuation)new Continuation<Boolean, Task<Boolean>>(){

            public Task<Boolean> then(Task<Boolean> task) throws Exception {
                if (!task.isCancelled() && !task.isFaulted() && ((Boolean)task.getResult()).booleanValue()) {
                    return Task.forResult((Object)true);
                }
                return ImagePipeline.this.mSmallImageBufferedDiskCache.contains(cacheKey);
            }
        }).continueWith((Continuation)new Continuation<Boolean, Void>(){

            public Void then(Task<Boolean> task) throws Exception {
                dataSource.setResult((Object)(!task.isCancelled() && !task.isFaulted() && (Boolean)task.getResult() != false ? 1 : 0));
                return null;
            }
        });
        return dataSource;
    }

    @Nullable
    public CacheKey getCacheKey(@Nullable ImageRequest imageRequest, @Nullable Object callerContext) {
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.beginSection((String)"ImagePipeline#getCacheKey");
        }
        CacheKeyFactory cacheKeyFactory = this.mCacheKeyFactory;
        CacheKey cacheKey = null;
        if (cacheKeyFactory != null && imageRequest != null) {
            cacheKey = imageRequest.getPostprocessor() != null ? cacheKeyFactory.getPostprocessedBitmapCacheKey(imageRequest, callerContext) : cacheKeyFactory.getBitmapCacheKey(imageRequest, callerContext);
        }
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.endSection();
        }
        return cacheKey;
    }

    @Nullable
    public CloseableReference<CloseableImage> getCachedImage(@Nullable CacheKey cacheKey) {
        MemoryCache<CacheKey, CloseableImage> memoryCache = this.mBitmapMemoryCache;
        if (memoryCache == null || cacheKey == null) {
            return null;
        }
        CloseableReference closeableImage = memoryCache.get((Object)cacheKey);
        if (closeableImage != null && !((CloseableImage)closeableImage.get()).getQualityInfo().isOfFullQuality()) {
            closeableImage.close();
            return null;
        }
        return closeableImage;
    }

    public boolean hasCachedImage(@Nullable CacheKey cacheKey) {
        MemoryCache<CacheKey, CloseableImage> memoryCache = this.mBitmapMemoryCache;
        if (memoryCache == null || cacheKey == null) {
            return false;
        }
        return memoryCache.contains((Object)cacheKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> DataSource<CloseableReference<T>> submitFetchRequest(Producer<CloseableReference<T>> producerSequence, ImageRequest imageRequest, ImageRequest.RequestLevel lowestPermittedRequestLevelOnSubmit, Object callerContext, @Nullable RequestListener requestListener, @Nullable String uiComponentId) {
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.beginSection((String)"ImagePipeline#submitFetchRequest");
        }
        InternalRequestListener requestListener2 = new InternalRequestListener(this.getRequestListenerForRequest(imageRequest, requestListener), this.mRequestListener2);
        if (this.mCallerContextVerifier != null) {
            this.mCallerContextVerifier.verifyCallerContext(callerContext, false);
        }
        try {
            ImageRequest.RequestLevel lowestPermittedRequestLevel = ImageRequest.RequestLevel.getMax(imageRequest.getLowestPermittedRequestLevel(), lowestPermittedRequestLevelOnSubmit);
            SettableProducerContext settableProducerContext = new SettableProducerContext(imageRequest, this.generateUniqueFutureId(), uiComponentId, requestListener2, callerContext, lowestPermittedRequestLevel, false, imageRequest.getProgressiveRenderingEnabled() || !UriUtil.isNetworkUri((Uri)imageRequest.getSourceUri()), imageRequest.getPriority(), this.mConfig);
            DataSource<CloseableReference<T>> dataSource = CloseableProducerToDataSourceAdapter.create(producerSequence, settableProducerContext, requestListener2);
            return dataSource;
        }
        catch (Exception exception) {
            DataSource dataSource = DataSources.immediateFailedDataSource((Throwable)exception);
            return dataSource;
        }
        finally {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> DataSource<CloseableReference<T>> submitFetchRequest(Producer<CloseableReference<T>> producerSequence, SettableProducerContext settableProducerContext, RequestListener requestListener) {
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.beginSection((String)"ImagePipeline#submitFetchRequest");
        }
        try {
            InternalRequestListener requestListener2 = new InternalRequestListener(requestListener, this.mRequestListener2);
            DataSource<CloseableReference<T>> dataSource = CloseableProducerToDataSourceAdapter.create(producerSequence, settableProducerContext, requestListener2);
            return dataSource;
        }
        catch (Exception exception) {
            DataSource dataSource = DataSources.immediateFailedDataSource((Throwable)exception);
            return dataSource;
        }
        finally {
            if (FrescoSystrace.isTracing()) {
                FrescoSystrace.endSection();
            }
        }
    }

    public ProducerSequenceFactory getProducerSequenceFactory() {
        return this.mProducerSequenceFactory;
    }

    private DataSource<Void> submitPrefetchRequest(Producer<Void> producerSequence, ImageRequest imageRequest, ImageRequest.RequestLevel lowestPermittedRequestLevelOnSubmit, Object callerContext, Priority priority, @Nullable RequestListener requestListener) {
        InternalRequestListener requestListener2 = new InternalRequestListener(this.getRequestListenerForRequest(imageRequest, requestListener), this.mRequestListener2);
        if (this.mCallerContextVerifier != null) {
            this.mCallerContextVerifier.verifyCallerContext(callerContext, true);
        }
        try {
            ImageRequest.RequestLevel lowestPermittedRequestLevel = ImageRequest.RequestLevel.getMax(imageRequest.getLowestPermittedRequestLevel(), lowestPermittedRequestLevelOnSubmit);
            SettableProducerContext settableProducerContext = new SettableProducerContext(imageRequest, this.generateUniqueFutureId(), requestListener2, callerContext, lowestPermittedRequestLevel, true, false, priority, this.mConfig);
            return ProducerToDataSourceAdapter.create(producerSequence, settableProducerContext, requestListener2);
        }
        catch (Exception exception) {
            return DataSources.immediateFailedDataSource((Throwable)exception);
        }
    }

    public RequestListener getRequestListenerForRequest(ImageRequest imageRequest, @Nullable RequestListener requestListener) {
        if (requestListener == null) {
            if (imageRequest.getRequestListener() == null) {
                return this.mRequestListener;
            }
            return new ForwardingRequestListener(this.mRequestListener, imageRequest.getRequestListener());
        }
        if (imageRequest.getRequestListener() == null) {
            return new ForwardingRequestListener(this.mRequestListener, requestListener);
        }
        return new ForwardingRequestListener(this.mRequestListener, requestListener, imageRequest.getRequestListener());
    }

    public RequestListener getCombinedRequestListener(@Nullable RequestListener listener) {
        if (listener == null) {
            return this.mRequestListener;
        }
        return new ForwardingRequestListener(this.mRequestListener, listener);
    }

    private Predicate<CacheKey> predicateForUri(final Uri uri) {
        return new Predicate<CacheKey>(){

            public boolean apply(CacheKey key) {
                return key.containsUri(uri);
            }
        };
    }

    public void pause() {
        this.mThreadHandoffProducerQueue.startQueueing();
    }

    public void resume() {
        this.mThreadHandoffProducerQueue.stopQueuing();
    }

    public boolean isPaused() {
        return this.mThreadHandoffProducerQueue.isQueueing();
    }

    public Supplier<Boolean> isLazyDataSource() {
        return this.mLazyDataSource;
    }

    public CacheKeyFactory getCacheKeyFactory() {
        return this.mCacheKeyFactory;
    }

    public ImagePipelineConfigInterface getConfig() {
        return this.mConfig;
    }
}

