/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.datasource;

import com.facebook.common.internal.Preconditions;
import com.facebook.datasource.AbstractDataSource;
import com.facebook.imagepipeline.listener.RequestListener2;
import com.facebook.imagepipeline.producers.BaseConsumer;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.SettableProducerContext;
import com.facebook.imagepipeline.request.HasImageRequest;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.systrace.FrescoSystrace;
import com.facebook.infer.annotation.Nullsafe;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@Nullsafe(value=Nullsafe.Mode.STRICT)
@ThreadSafe
public abstract class AbstractProducerToDataSourceAdapter<T>
extends AbstractDataSource<T>
implements HasImageRequest {
    private final SettableProducerContext mSettableProducerContext;
    private final RequestListener2 mRequestListener;

    protected AbstractProducerToDataSourceAdapter(Producer<T> producer, SettableProducerContext settableProducerContext, RequestListener2 requestListener) {
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.beginSection((String)"AbstractProducerToDataSourceAdapter()");
        }
        this.mSettableProducerContext = settableProducerContext;
        this.mRequestListener = requestListener;
        this.setInitialExtras();
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.beginSection((String)"AbstractProducerToDataSourceAdapter()->onRequestStart");
        }
        this.mRequestListener.onRequestStart(this.mSettableProducerContext);
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.endSection();
        }
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.beginSection((String)"AbstractProducerToDataSourceAdapter()->produceResult");
        }
        producer.produceResults(this.createConsumer(), settableProducerContext);
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.endSection();
        }
        if (FrescoSystrace.isTracing()) {
            FrescoSystrace.endSection();
        }
    }

    private Consumer<T> createConsumer() {
        return new BaseConsumer<T>(){

            @Override
            protected void onNewResultImpl(@Nullable T newResult, int status) {
                AbstractProducerToDataSourceAdapter.this.onNewResultImpl(newResult, status, AbstractProducerToDataSourceAdapter.this.mSettableProducerContext);
            }

            @Override
            protected void onFailureImpl(Throwable throwable) {
                AbstractProducerToDataSourceAdapter.this.onFailureImpl(throwable);
            }

            @Override
            protected void onCancellationImpl() {
                AbstractProducerToDataSourceAdapter.this.onCancellationImpl();
            }

            @Override
            protected void onProgressUpdateImpl(float progress) {
                AbstractProducerToDataSourceAdapter.this.setProgress(progress);
            }
        };
    }

    protected void onNewResultImpl(@Nullable T result, int status, ProducerContext producerContext) {
        boolean isLast = BaseConsumer.isLast(status);
        if (super.setResult(result, isLast, this.getExtras(producerContext)) && isLast) {
            this.mRequestListener.onRequestSuccess(this.mSettableProducerContext);
        }
    }

    protected Map<String, Object> getExtras(ProducerContext producerContext) {
        return producerContext.getExtras();
    }

    private void onFailureImpl(Throwable throwable) {
        if (super.setFailure(throwable, this.getExtras(this.mSettableProducerContext))) {
            this.mRequestListener.onRequestFailure(this.mSettableProducerContext, throwable);
        }
    }

    private synchronized void onCancellationImpl() {
        Preconditions.checkState((boolean)this.isClosed());
    }

    @Override
    public ImageRequest getImageRequest() {
        return this.mSettableProducerContext.getImageRequest();
    }

    public boolean close() {
        if (!super.close()) {
            return false;
        }
        if (!super.isFinished()) {
            this.mRequestListener.onRequestCancellation(this.mSettableProducerContext);
            this.mSettableProducerContext.cancel();
        }
        return true;
    }

    private void setInitialExtras() {
        this.setExtras(this.mSettableProducerContext.getExtras());
    }
}

