/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.bitmaps;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.core.CloseableReferenceFactory;
import com.facebook.imagepipeline.memory.BitmapPool;
import com.facebook.imageutils.BitmapUtil;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.concurrent.ThreadSafe;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
@TargetApi(value=21)
@ThreadSafe
public class ArtBitmapFactory
extends PlatformBitmapFactory {
    private final BitmapPool mBitmapPool;
    private final CloseableReferenceFactory mCloseableReferenceFactory;

    public ArtBitmapFactory(BitmapPool bitmapPool, CloseableReferenceFactory closeableReferenceFactory) {
        this.mBitmapPool = bitmapPool;
        this.mCloseableReferenceFactory = closeableReferenceFactory;
    }

    public CloseableReference<Bitmap> createBitmapInternal(int width, int height, Bitmap.Config bitmapConfig) {
        int sizeInBytes = BitmapUtil.getSizeInByteForBitmap((int)width, (int)height, (Bitmap.Config)bitmapConfig);
        Bitmap bitmap = (Bitmap)this.mBitmapPool.get(sizeInBytes);
        Preconditions.checkArgument((Boolean)(bitmap.getAllocationByteCount() >= width * height * BitmapUtil.getPixelSizeForBitmapConfig((Bitmap.Config)bitmapConfig) ? 1 : 0));
        bitmap.reconfigure(width, height, bitmapConfig);
        return this.mCloseableReferenceFactory.create(bitmap, this.mBitmapPool);
    }
}

