/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.platform;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import androidx.core.util.Pools;
import androidx.core.util.Preconditions;
import com.facebook.imagepipeline.memory.BitmapPool;
import com.facebook.imagepipeline.platform.DefaultDecoder;
import com.facebook.imageutils.BitmapUtil;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.concurrent.ThreadSafe;

@TargetApi(value=21)
@ThreadSafe
@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class ArtDecoder
extends DefaultDecoder {
    public ArtDecoder(BitmapPool bitmapPool, int maxNumThreads, Pools.SynchronizedPool decodeBuffers) {
        super(bitmapPool, maxNumThreads, decodeBuffers);
    }

    @Override
    public int getBitmapSize(int width, int height, BitmapFactory.Options options) {
        Bitmap.Config c = (Bitmap.Config)Preconditions.checkNotNull((Object)options.inPreferredConfig);
        return BitmapUtil.getSizeInByteForBitmap((int)width, (int)height, (Bitmap.Config)c);
    }
}

