/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.common.references.CloseableReference;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.infer.annotation.Nullsafe;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class DelayProducer
implements Producer<CloseableReference<CloseableImage>> {
    private final Producer<CloseableReference<CloseableImage>> mInputProducer;
    @Nullable
    private final ScheduledExecutorService mBackgroundTasksExecutor;

    public DelayProducer(Producer<CloseableReference<CloseableImage>> inputProducer, @Nullable ScheduledExecutorService backgroundTasksExecutor) {
        this.mInputProducer = inputProducer;
        this.mBackgroundTasksExecutor = backgroundTasksExecutor;
    }

    @Override
    public void produceResults(final Consumer<CloseableReference<CloseableImage>> consumer, final ProducerContext context) {
        ImageRequest request = context.getImageRequest();
        if (this.mBackgroundTasksExecutor != null) {
            this.mBackgroundTasksExecutor.schedule(new Runnable(){

                @Override
                public void run() {
                    DelayProducer.this.mInputProducer.produceResults(consumer, context);
                }
            }, (long)request.getDelayMs(), TimeUnit.MILLISECONDS);
        } else {
            this.mInputProducer.produceResults(consumer, context);
        }
    }
}

