/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.platform;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import androidx.core.util.Pools;
import com.facebook.imagepipeline.memory.BitmapPool;
import com.facebook.imagepipeline.platform.DefaultDecoder;
import com.facebook.imageutils.BitmapUtil;
import java.nio.ByteBuffer;
import javax.annotation.concurrent.ThreadSafe;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/facebook/imagepipeline/platform/ArtDecoder;", "Lcom/facebook/imagepipeline/platform/DefaultDecoder;", "bitmapPool", "Lcom/facebook/imagepipeline/memory/BitmapPool;", "decodeBuffers", "Landroidx/core/util/Pools$Pool;", "Ljava/nio/ByteBuffer;", "(Lcom/facebook/imagepipeline/memory/BitmapPool;Landroidx/core/util/Pools$Pool;)V", "getBitmapSize", "", "width", "height", "options", "Landroid/graphics/BitmapFactory$Options;", "imagepipeline_release"})
@TargetApi(value=21)
@ThreadSafe
public final class ArtDecoder
extends DefaultDecoder {
    public ArtDecoder(@NotNull BitmapPool bitmapPool, @NotNull Pools.Pool<ByteBuffer> decodeBuffers) {
        Intrinsics.checkNotNullParameter((Object)bitmapPool, (String)"bitmapPool");
        Intrinsics.checkNotNullParameter(decodeBuffers, (String)"decodeBuffers");
        super(bitmapPool, decodeBuffers);
    }

    @Override
    public int getBitmapSize(int width, int height, @NotNull BitmapFactory.Options options) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Bitmap.Config config = options.inPreferredConfig;
        if (config == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        Bitmap.Config c = config;
        return BitmapUtil.getSizeInByteForBitmap((int)width, (int)height, (Bitmap.Config)c);
    }
}

