/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import androidx.annotation.VisibleForTesting;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.memory.PooledByteBufferFactory;
import com.facebook.common.memory.PooledByteBufferOutputStream;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.util.TriState;
import com.facebook.imageformat.DefaultImageFormats;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.common.RotationOptions;
import com.facebook.imagepipeline.image.EncodedImage;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.DelegatingConsumer;
import com.facebook.imagepipeline.producers.JobScheduler;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.transcoder.ImageTranscodeResult;
import com.facebook.imagepipeline.transcoder.ImageTranscoder;
import com.facebook.imagepipeline.transcoder.ImageTranscoderFactory;
import com.facebook.imagepipeline.transcoder.JpegTranscoderUtils;
import com.facebook.infer.annotation.Nullsafe;
import java.io.Closeable;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class ResizeAndRotateProducer
implements Producer<EncodedImage> {
    private static final String PRODUCER_NAME = "ResizeAndRotateProducer";
    private static final String INPUT_IMAGE_FORMAT = "Image format";
    private static final String ORIGINAL_SIZE_KEY = "Original size";
    private static final String REQUESTED_SIZE_KEY = "Requested size";
    private static final String TRANSCODING_RESULT = "Transcoding result";
    private static final String TRANSCODER_ID = "Transcoder id";
    @VisibleForTesting
    static final int MIN_TRANSFORM_INTERVAL_MS = 100;
    private final Executor mExecutor;
    private final PooledByteBufferFactory mPooledByteBufferFactory;
    private final Producer<EncodedImage> mInputProducer;
    private final boolean mIsResizingEnabled;
    private final ImageTranscoderFactory mImageTranscoderFactory;

    public ResizeAndRotateProducer(Executor executor, PooledByteBufferFactory pooledByteBufferFactory, Producer<EncodedImage> inputProducer, boolean isResizingEnabled, ImageTranscoderFactory imageTranscoderFactory) {
        this.mExecutor = (Executor)Preconditions.checkNotNull((Object)executor);
        this.mPooledByteBufferFactory = (PooledByteBufferFactory)Preconditions.checkNotNull((Object)pooledByteBufferFactory);
        this.mInputProducer = (Producer)Preconditions.checkNotNull(inputProducer);
        this.mImageTranscoderFactory = (ImageTranscoderFactory)Preconditions.checkNotNull((Object)imageTranscoderFactory);
        this.mIsResizingEnabled = isResizingEnabled;
    }

    @Override
    public void produceResults(Consumer<EncodedImage> consumer, ProducerContext context) {
        this.mInputProducer.produceResults(new TransformingConsumer(consumer, context, this.mIsResizingEnabled, this.mImageTranscoderFactory), context);
    }

    private static TriState shouldTransform(ImageRequest request, EncodedImage encodedImage, ImageTranscoder imageTranscoder) {
        if (encodedImage == null || encodedImage.getImageFormat() == ImageFormat.UNKNOWN) {
            return TriState.UNSET;
        }
        if (!imageTranscoder.canTranscode(encodedImage.getImageFormat())) {
            return TriState.NO;
        }
        return TriState.valueOf((ResizeAndRotateProducer.shouldRotate(request.getRotationOptions(), encodedImage) || imageTranscoder.canResize(encodedImage, request.getRotationOptions(), request.getResizeOptions()) ? 1 : 0) != 0);
    }

    private static boolean shouldRotate(RotationOptions rotationOptions, EncodedImage encodedImage) {
        return !rotationOptions.canDeferUntilRendered() && (JpegTranscoderUtils.getRotationAngle((RotationOptions)rotationOptions, (EncodedImage)encodedImage) != 0 || ResizeAndRotateProducer.shouldRotateUsingExifOrientation(rotationOptions, encodedImage));
    }

    private static boolean shouldRotateUsingExifOrientation(RotationOptions rotationOptions, EncodedImage encodedImage) {
        if (!rotationOptions.rotationEnabled() || rotationOptions.canDeferUntilRendered()) {
            encodedImage.setExifOrientation(0);
            return false;
        }
        return JpegTranscoderUtils.INVERTED_EXIF_ORIENTATIONS.contains((Object)encodedImage.getExifOrientation());
    }

    private class TransformingConsumer
    extends DelegatingConsumer<EncodedImage, EncodedImage> {
        private final boolean mIsResizingEnabled;
        private final ImageTranscoderFactory mImageTranscoderFactory;
        private final ProducerContext mProducerContext;
        private boolean mIsCancelled;
        private final JobScheduler mJobScheduler;

        TransformingConsumer(final Consumer<EncodedImage> consumer, ProducerContext producerContext, boolean isResizingEnabled, ImageTranscoderFactory imageTranscoderFactory) {
            super(consumer);
            this.mIsCancelled = false;
            this.mProducerContext = producerContext;
            Boolean resizingAllowedOverride = this.mProducerContext.getImageRequest().getResizingAllowedOverride();
            this.mIsResizingEnabled = resizingAllowedOverride != null ? resizingAllowedOverride : isResizingEnabled;
            this.mImageTranscoderFactory = imageTranscoderFactory;
            JobScheduler.JobRunnable job = new JobScheduler.JobRunnable(){

                @Override
                public void run(@Nullable EncodedImage encodedImage, int status) {
                    if (encodedImage != null) {
                        TransformingConsumer.this.doTransform(encodedImage, status, (ImageTranscoder)Preconditions.checkNotNull((Object)TransformingConsumer.this.mImageTranscoderFactory.createImageTranscoder(encodedImage.getImageFormat(), TransformingConsumer.this.mIsResizingEnabled)));
                    } else {
                        TransformingConsumer.this.getConsumer().onNewResult(null, status);
                    }
                }
            };
            this.mJobScheduler = new JobScheduler(ResizeAndRotateProducer.this.mExecutor, job, 100);
            this.mProducerContext.addCallbacks(new BaseProducerContextCallbacks(){

                @Override
                public void onIsIntermediateResultExpectedChanged() {
                    if (TransformingConsumer.this.mProducerContext.isIntermediateResultExpected()) {
                        TransformingConsumer.this.mJobScheduler.scheduleJob();
                    }
                }

                @Override
                public void onCancellationRequested() {
                    TransformingConsumer.this.mJobScheduler.clearJob();
                    TransformingConsumer.this.mIsCancelled = true;
                    consumer.onCancellation();
                }
            });
        }

        @Override
        protected void onNewResultImpl(@Nullable EncodedImage newResult, int status) {
            if (this.mIsCancelled) {
                return;
            }
            boolean isLast = TransformingConsumer.isLast(status);
            if (newResult == null) {
                if (isLast) {
                    this.getConsumer().onNewResult(null, 1);
                }
                return;
            }
            ImageFormat imageFormat = newResult.getImageFormat();
            TriState shouldTransform = ResizeAndRotateProducer.shouldTransform(this.mProducerContext.getImageRequest(), newResult, (ImageTranscoder)Preconditions.checkNotNull((Object)this.mImageTranscoderFactory.createImageTranscoder(imageFormat, this.mIsResizingEnabled)));
            if (!isLast && shouldTransform == TriState.UNSET) {
                return;
            }
            if (shouldTransform != TriState.YES) {
                this.forwardNewResult(newResult, status, imageFormat);
                return;
            }
            if (!this.mJobScheduler.updateJob(newResult, status)) {
                return;
            }
            if (isLast || this.mProducerContext.isIntermediateResultExpected()) {
                this.mJobScheduler.scheduleJob();
            }
        }

        private void forwardNewResult(EncodedImage newResult, int status, ImageFormat imageFormat) {
            newResult = imageFormat == DefaultImageFormats.JPEG || imageFormat == DefaultImageFormats.HEIF ? this.getNewResultsForJpegOrHeif(newResult) : this.getNewResultForImagesWithoutExifData(newResult);
            this.getConsumer().onNewResult(newResult, status);
        }

        @Nullable
        private EncodedImage getNewResultForImagesWithoutExifData(EncodedImage encodedImage) {
            RotationOptions options = this.mProducerContext.getImageRequest().getRotationOptions();
            if (!options.useImageMetadata() && options.rotationEnabled()) {
                encodedImage = this.getCloneWithRotationApplied(encodedImage, options.getForcedAngle());
            }
            return encodedImage;
        }

        @Nullable
        private EncodedImage getNewResultsForJpegOrHeif(EncodedImage encodedImage) {
            if (!this.mProducerContext.getImageRequest().getRotationOptions().canDeferUntilRendered() && encodedImage.getRotationAngle() != 0 && encodedImage.getRotationAngle() != -1) {
                encodedImage = this.getCloneWithRotationApplied(encodedImage, 0);
            }
            return encodedImage;
        }

        @Nullable
        private EncodedImage getCloneWithRotationApplied(EncodedImage encodedImage, int angle) {
            EncodedImage newResult = EncodedImage.cloneOrNull((EncodedImage)encodedImage);
            if (newResult != null) {
                newResult.setRotationAngle(angle);
            }
            return newResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doTransform(EncodedImage encodedImage, int status, ImageTranscoder imageTranscoder) {
            this.mProducerContext.getProducerListener().onProducerStart(this.mProducerContext, ResizeAndRotateProducer.PRODUCER_NAME);
            ImageRequest imageRequest = this.mProducerContext.getImageRequest();
            Map<String, String> extraMap = null;
            try (PooledByteBufferOutputStream outputStream = ResizeAndRotateProducer.this.mPooledByteBufferFactory.newOutputStream();){
                ImageTranscodeResult result = imageTranscoder.transcode(encodedImage, (OutputStream)outputStream, imageRequest.getRotationOptions(), imageRequest.getResizeOptions(), null, Integer.valueOf(85));
                if (result.getTranscodeStatus() == 2) {
                    throw new RuntimeException("Error while transcoding the image");
                }
                extraMap = this.getExtraMap(encodedImage, imageRequest.getResizeOptions(), result, imageTranscoder.getIdentifier());
                CloseableReference ref = CloseableReference.of((Closeable)outputStream.toByteBuffer());
                try {
                    EncodedImage ret = new EncodedImage(ref);
                    ret.setImageFormat(DefaultImageFormats.JPEG);
                    try {
                        ret.parseMetaData();
                        this.mProducerContext.getProducerListener().onProducerFinishWithSuccess(this.mProducerContext, ResizeAndRotateProducer.PRODUCER_NAME, extraMap);
                        if (result.getTranscodeStatus() != 1) {
                            status |= 0x10;
                        }
                        this.getConsumer().onNewResult(ret, status);
                    }
                    finally {
                        EncodedImage.closeSafely((EncodedImage)ret);
                    }
                }
                finally {
                    CloseableReference.closeSafely((CloseableReference)ref);
                }
            }
        }

        @Nullable
        private Map<String, String> getExtraMap(EncodedImage encodedImage, @Nullable ResizeOptions resizeOptions, @Nullable ImageTranscodeResult transcodeResult, @Nullable String transcoderId) {
            if (!this.mProducerContext.getProducerListener().requiresExtraMap(this.mProducerContext, ResizeAndRotateProducer.PRODUCER_NAME)) {
                return null;
            }
            String originalSize = encodedImage.getWidth() + "x" + encodedImage.getHeight();
            String requestedSize = resizeOptions != null ? resizeOptions.width + "x" + resizeOptions.height : "Unspecified";
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(ResizeAndRotateProducer.INPUT_IMAGE_FORMAT, String.valueOf(encodedImage.getImageFormat()));
            map.put(ResizeAndRotateProducer.ORIGINAL_SIZE_KEY, originalSize);
            map.put(ResizeAndRotateProducer.REQUESTED_SIZE_KEY, requestedSize);
            map.put("queueTime", String.valueOf(this.mJobScheduler.getQueuedTime()));
            map.put(ResizeAndRotateProducer.TRANSCODER_ID, transcoderId);
            map.put(ResizeAndRotateProducer.TRANSCODING_RESULT, String.valueOf(transcodeResult));
            return ImmutableMap.copyOf(map);
        }
    }
}

