/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.filter;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import androidx.annotation.RequiresApi;
import com.facebook.common.internal.Preconditions;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0007J\b\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/facebook/imagepipeline/filter/RenderScriptBlurFilter;", "", "()V", "BLUR_MAX_RADIUS", "", "blurBitmap", "", "dest", "Landroid/graphics/Bitmap;", "src", "context", "Landroid/content/Context;", "radius", "canUseRenderScript", "", "imagepipeline_release"})
public final class RenderScriptBlurFilter {
    @NotNull
    public static final RenderScriptBlurFilter INSTANCE = new RenderScriptBlurFilter();
    public static final int BLUR_MAX_RADIUS = 25;

    private RenderScriptBlurFilter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @RequiresApi(value=17)
    public static final void blurBitmap(@NotNull Bitmap dest, @NotNull Bitmap src, @NotNull Context context, int radius) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Preconditions.checkNotNull((Object)dest);
        Preconditions.checkNotNull((Object)src);
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkArgument((Boolean)(radius > 0 && radius <= 25 ? 1 : 0));
        RenderScript rs = null;
        try {
            rs = (RenderScript)Preconditions.checkNotNull((Object)RenderScript.create((Context)context));
            ScriptIntrinsicBlur blurScript = ScriptIntrinsicBlur.create((RenderScript)rs, (Element)Element.U8_4((RenderScript)rs));
            Allocation allIn = (Allocation)Preconditions.checkNotNull((Object)Allocation.createFromBitmap((RenderScript)rs, (Bitmap)src));
            Allocation allOut = (Allocation)Preconditions.checkNotNull((Object)Allocation.createFromBitmap((RenderScript)rs, (Bitmap)dest));
            blurScript.setRadius((float)radius);
            blurScript.setInput(allIn);
            blurScript.forEach(allOut);
            allOut.copyTo(dest);
            blurScript.destroy();
            allIn.destroy();
            allOut.destroy();
        }
        finally {
            RenderScript renderScript = rs;
            if (renderScript != null) {
                renderScript.destroy();
            }
        }
    }

    @JvmStatic
    public static final boolean canUseRenderScript() {
        return Build.VERSION.SDK_INT >= 17;
    }
}

