/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import android.content.ContentResolver;
import android.graphics.Bitmap;
import android.os.CancellationSignal;
import android.util.Size;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.facebook.common.internal.ImmutableMap;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.imagepipeline.bitmaps.SimpleBitmapReleaser;
import com.facebook.imagepipeline.image.CloseableImage;
import com.facebook.imagepipeline.image.CloseableStaticBitmap;
import com.facebook.imagepipeline.image.ImmutableQualityInfo;
import com.facebook.imagepipeline.image.QualityInfo;
import com.facebook.imagepipeline.producers.BaseProducerContextCallbacks;
import com.facebook.imagepipeline.producers.Consumer;
import com.facebook.imagepipeline.producers.Producer;
import com.facebook.imagepipeline.producers.ProducerContext;
import com.facebook.imagepipeline.producers.ProducerListener2;
import com.facebook.imagepipeline.producers.StatefulProducerRunnable;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.infer.annotation.Nullsafe;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

@RequiresApi(value=29)
@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class LocalThumbnailBitmapProducer
implements Producer<CloseableReference<CloseableImage>> {
    public static final String PRODUCER_NAME = "LocalThumbnailBitmapProducer";
    @VisibleForTesting
    static final String CREATED_THUMBNAIL = "createdThumbnail";
    private final Executor mExecutor;
    private final ContentResolver mContentResolver;

    public LocalThumbnailBitmapProducer(Executor executor, ContentResolver contentResolver) {
        this.mExecutor = executor;
        this.mContentResolver = contentResolver;
    }

    @Override
    public void produceResults(Consumer<CloseableReference<CloseableImage>> consumer, final ProducerContext context) {
        final ProducerListener2 listener = context.getProducerListener();
        final ImageRequest imageRequest = context.getImageRequest();
        context.putOriginExtra("local", "thumbnail_bitmap");
        final CancellationSignal cancellationSignal = new CancellationSignal();
        final StatefulProducerRunnable<CloseableReference<CloseableImage>> cancellableProducerRunnable = new StatefulProducerRunnable<CloseableReference<CloseableImage>>(consumer, listener, context, PRODUCER_NAME){

            @Override
            protected void onSuccess(@Nullable CloseableReference<CloseableImage> result) {
                super.onSuccess(result);
                listener.onUltimateProducerReached(context, LocalThumbnailBitmapProducer.PRODUCER_NAME, result != null);
                context.putOriginExtra("local");
            }

            @Override
            protected void onFailure(Exception e) {
                super.onFailure(e);
                listener.onUltimateProducerReached(context, LocalThumbnailBitmapProducer.PRODUCER_NAME, false);
                context.putOriginExtra("local");
            }

            @Nullable
            protected CloseableReference<CloseableImage> getResult() throws IOException {
                Bitmap thumbnailBitmap = LocalThumbnailBitmapProducer.this.mContentResolver.loadThumbnail(imageRequest.getSourceUri(), new Size(imageRequest.getPreferredWidth(), imageRequest.getPreferredHeight()), cancellationSignal);
                if (thumbnailBitmap == null) {
                    return null;
                }
                CloseableStaticBitmap closeableStaticBitmap = CloseableStaticBitmap.of((Bitmap)thumbnailBitmap, (ResourceReleaser)SimpleBitmapReleaser.getInstance(), (QualityInfo)ImmutableQualityInfo.FULL_QUALITY, (int)0);
                context.putExtra("image_format", "thumbnail");
                closeableStaticBitmap.putExtras(context.getExtras());
                return CloseableReference.of((Closeable)closeableStaticBitmap);
            }

            @Override
            protected void onCancellation() {
                super.onCancellation();
                cancellationSignal.cancel();
            }

            @Override
            protected Map<String, String> getExtraMapOnSuccess(@Nullable CloseableReference<CloseableImage> result) {
                return ImmutableMap.of((Object)LocalThumbnailBitmapProducer.CREATED_THUMBNAIL, (Object)String.valueOf(result != null));
            }

            @Override
            protected void disposeResult(@Nullable CloseableReference<CloseableImage> result) {
                CloseableReference.closeSafely(result);
            }
        };
        context.addCallbacks(new BaseProducerContextCallbacks(){

            @Override
            public void onCancellationRequested() {
                cancellableProducerRunnable.cancel();
            }
        });
        this.mExecutor.execute((Runnable)((Object)cancellableProducerRunnable));
    }
}

