/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.cache;

import com.facebook.common.internal.Supplier;
import com.facebook.imagepipeline.cache.MemoryCacheParams;
import com.facebook.infer.annotation.Nullsafe;
import java.util.concurrent.TimeUnit;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public class DefaultEncodedMemoryCacheParamsSupplier
implements Supplier<MemoryCacheParams> {
    private static final int MAX_CACHE_ENTRIES = Integer.MAX_VALUE;
    private static final int MAX_EVICTION_QUEUE_ENTRIES = Integer.MAX_VALUE;
    private static final long PARAMS_CHECK_INTERVAL_MS = TimeUnit.MINUTES.toMillis(5L);

    public MemoryCacheParams get() {
        int maxCacheSize = this.getMaxCacheSize();
        int maxCacheEntrySize = maxCacheSize / 8;
        return new MemoryCacheParams(maxCacheSize, Integer.MAX_VALUE, maxCacheSize, Integer.MAX_VALUE, maxCacheEntrySize, PARAMS_CHECK_INTERVAL_MS);
    }

    private int getMaxCacheSize() {
        int maxMemory = (int)Math.min(Runtime.getRuntime().maxMemory(), Integer.MAX_VALUE);
        if (maxMemory < 0x1000000) {
            return 0x100000;
        }
        if (maxMemory < 0x2000000) {
            return 0x200000;
        }
        return 0x400000;
    }
}

