/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.bitmaps;

import android.os.Build;
import com.facebook.imagepipeline.bitmaps.ArtBitmapFactory;
import com.facebook.imagepipeline.bitmaps.EmptyJpegGenerator;
import com.facebook.imagepipeline.bitmaps.HoneycombBitmapFactory;
import com.facebook.imagepipeline.bitmaps.PlatformBitmapFactory;
import com.facebook.imagepipeline.core.CloseableReferenceFactory;
import com.facebook.imagepipeline.memory.BitmapPool;
import com.facebook.imagepipeline.memory.PoolFactory;
import com.facebook.imagepipeline.platform.PlatformDecoder;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/facebook/imagepipeline/bitmaps/PlatformBitmapFactoryProvider;", "", "()V", "buildPlatformBitmapFactory", "Lcom/facebook/imagepipeline/bitmaps/PlatformBitmapFactory;", "poolFactory", "Lcom/facebook/imagepipeline/memory/PoolFactory;", "platformDecoder", "Lcom/facebook/imagepipeline/platform/PlatformDecoder;", "closeableReferenceFactory", "Lcom/facebook/imagepipeline/core/CloseableReferenceFactory;", "imagepipeline_release"})
public final class PlatformBitmapFactoryProvider {
    @NotNull
    public static final PlatformBitmapFactoryProvider INSTANCE = new PlatformBitmapFactoryProvider();

    private PlatformBitmapFactoryProvider() {
    }

    @JvmStatic
    @NotNull
    public static final PlatformBitmapFactory buildPlatformBitmapFactory(@NotNull PoolFactory poolFactory, @NotNull PlatformDecoder platformDecoder, @NotNull CloseableReferenceFactory closeableReferenceFactory) {
        PlatformBitmapFactory platformBitmapFactory;
        Intrinsics.checkNotNullParameter((Object)poolFactory, (String)"poolFactory");
        Intrinsics.checkNotNullParameter((Object)platformDecoder, (String)"platformDecoder");
        Intrinsics.checkNotNullParameter((Object)closeableReferenceFactory, (String)"closeableReferenceFactory");
        if (Build.VERSION.SDK_INT >= 21) {
            BitmapPool bitmapPool = poolFactory.getBitmapPool();
            Intrinsics.checkNotNullExpressionValue((Object)bitmapPool, (String)"poolFactory.bitmapPool");
            platformBitmapFactory = new ArtBitmapFactory(bitmapPool, closeableReferenceFactory);
        } else {
            platformBitmapFactory = new HoneycombBitmapFactory(new EmptyJpegGenerator(poolFactory.getPooledByteBufferFactory()), platformDecoder, closeableReferenceFactory);
        }
        return platformBitmapFactory;
    }
}

