/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.producers;

import com.facebook.imagepipeline.cache.BufferedDiskCache;
import com.facebook.imagepipeline.request.ImageRequest;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u00042\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0004\u0018\u00010\nH\u0007\u00a8\u0006\r"}, d2={"Lcom/facebook/imagepipeline/producers/DiskCacheDecision;", "", "()V", "chooseDiskCacheForRequest", "Lcom/facebook/imagepipeline/cache/BufferedDiskCache;", "imageRequest", "Lcom/facebook/imagepipeline/request/ImageRequest;", "smallDiskCache", "defaultDiskCache", "dynamicDiskCaches", "", "", "DiskCacheDecisionNoDiskCacheChosenException", "imagepipeline_release"})
public final class DiskCacheDecision {
    @NotNull
    public static final DiskCacheDecision INSTANCE = new DiskCacheDecision();

    private DiskCacheDecision() {
    }

    @JvmStatic
    @Nullable
    public static final BufferedDiskCache chooseDiskCacheForRequest(@NotNull ImageRequest imageRequest, @Nullable BufferedDiskCache smallDiskCache, @Nullable BufferedDiskCache defaultDiskCache, @Nullable Map<String, BufferedDiskCache> dynamicDiskCaches) {
        String diskCacheId;
        Intrinsics.checkNotNullParameter((Object)imageRequest, (String)"imageRequest");
        if (imageRequest.getCacheChoice() == ImageRequest.CacheChoice.SMALL) {
            return smallDiskCache;
        }
        if (imageRequest.getCacheChoice() == ImageRequest.CacheChoice.DEFAULT) {
            return defaultDiskCache;
        }
        if (imageRequest.getCacheChoice() == ImageRequest.CacheChoice.DYNAMIC && dynamicDiskCaches != null && (diskCacheId = imageRequest.getDiskCacheId()) != null) {
            return dynamicDiskCaches.get(diskCacheId);
        }
        return null;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00060\u0001j\u0002`\u0002B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/facebook/imagepipeline/producers/DiskCacheDecision$DiskCacheDecisionNoDiskCacheChosenException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "message", "", "(Ljava/lang/String;)V", "imagepipeline_release"})
    public static final class DiskCacheDecisionNoDiskCacheChosenException
    extends Exception {
        public DiskCacheDecisionNoDiskCacheChosenException(@Nullable String message) {
            super(message);
        }
    }
}

