/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.request;

import android.net.Uri;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.util.UriUtil;
import com.facebook.imagepipeline.common.BytesRange;
import com.facebook.imagepipeline.common.ImageDecodeOptions;
import com.facebook.imagepipeline.common.Priority;
import com.facebook.imagepipeline.common.ResizeOptions;
import com.facebook.imagepipeline.common.RotationOptions;
import com.facebook.imagepipeline.core.ImagePipelineConfig;
import com.facebook.imagepipeline.listener.RequestListener;
import com.facebook.imagepipeline.request.ImageRequest;
import com.facebook.imagepipeline.request.Postprocessor;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

public class ImageRequestBuilder {
    private static final Set<String> CUSTOM_NETWORK_SCHEMES = new HashSet<String>();
    @Nullable
    private Uri mSourceUri = null;
    private ImageRequest.RequestLevel mLowestPermittedRequestLevel = ImageRequest.RequestLevel.FULL_FETCH;
    private int mCachesDisabled = 0;
    @Nullable
    private ResizeOptions mResizeOptions = null;
    @Nullable
    private RotationOptions mRotationOptions = null;
    private ImageDecodeOptions mImageDecodeOptions = ImageDecodeOptions.defaults();
    private ImageRequest.CacheChoice mCacheChoice = ImageRequest.CacheChoice.DEFAULT;
    private boolean mProgressiveRenderingEnabled = ImagePipelineConfig.getDefaultImageRequestConfig().isProgressiveRenderingEnabled();
    private boolean mLocalThumbnailPreviewsEnabled = false;
    private boolean mLoadThumbnailOnly = false;
    private Priority mRequestPriority = Priority.HIGH;
    @Nullable
    private Postprocessor mPostprocessor = null;
    @Nullable
    private Boolean mDecodePrefetches = null;
    @Nullable
    private RequestListener mRequestListener;
    @Nullable
    private BytesRange mBytesRange = null;
    @Nullable
    private Boolean mResizingAllowedOverride = null;
    private int mDelayMs;
    @Nullable
    private String mDiskCacheId = null;

    public static ImageRequestBuilder newBuilderWithSource(Uri uri) {
        return new ImageRequestBuilder().setSource(uri);
    }

    public static ImageRequestBuilder newBuilderWithResourceId(int resId) {
        return ImageRequestBuilder.newBuilderWithSource(UriUtil.getUriForResourceId((int)resId));
    }

    public static ImageRequestBuilder fromRequest(ImageRequest imageRequest) {
        return ImageRequestBuilder.newBuilderWithSource(imageRequest.getSourceUri()).setImageDecodeOptions(imageRequest.getImageDecodeOptions()).setBytesRange(imageRequest.getBytesRange()).setCacheChoice(imageRequest.getCacheChoice()).setLocalThumbnailPreviewsEnabled(imageRequest.getLocalThumbnailPreviewsEnabled()).setLoadThumbnailOnly(imageRequest.getLoadThumbnailOnlyForAndroidSdkAboveQ()).setLowestPermittedRequestLevel(imageRequest.getLowestPermittedRequestLevel()).setCachesDisabled(imageRequest.getCachesDisabled()).setPostprocessor(imageRequest.getPostprocessor()).setProgressiveRenderingEnabled(imageRequest.getProgressiveRenderingEnabled()).setRequestPriority(imageRequest.getPriority()).setResizeOptions(imageRequest.getResizeOptions()).setRequestListener(imageRequest.getRequestListener()).setRotationOptions(imageRequest.getRotationOptions()).setShouldDecodePrefetches(imageRequest.shouldDecodePrefetches()).setDelayMs(imageRequest.getDelayMs()).setDiskCacheId(imageRequest.getDiskCacheId());
    }

    public static void addCustomUriNetworkScheme(String scheme) {
        CUSTOM_NETWORK_SCHEMES.add(scheme);
    }

    private ImageRequestBuilder() {
    }

    public ImageRequestBuilder setSource(Uri uri) {
        Preconditions.checkNotNull((Object)uri);
        this.mSourceUri = uri;
        return this;
    }

    public Uri getSourceUri() {
        return this.mSourceUri;
    }

    public ImageRequestBuilder setLowestPermittedRequestLevel(ImageRequest.RequestLevel requestLevel) {
        this.mLowestPermittedRequestLevel = requestLevel;
        return this;
    }

    public ImageRequest.RequestLevel getLowestPermittedRequestLevel() {
        return this.mLowestPermittedRequestLevel;
    }

    private ImageRequestBuilder setCachesDisabled(int cachesDisabled) {
        this.mCachesDisabled = cachesDisabled;
        if (this.mCacheChoice != ImageRequest.CacheChoice.DYNAMIC) {
            this.mDiskCacheId = null;
        }
        return this;
    }

    public int getCachesDisabled() {
        return this.mCachesDisabled;
    }

    @Deprecated
    public ImageRequestBuilder setAutoRotateEnabled(boolean enabled) {
        if (enabled) {
            return this.setRotationOptions(RotationOptions.autoRotate());
        }
        return this.setRotationOptions(RotationOptions.disableRotation());
    }

    public ImageRequestBuilder setResizeOptions(@Nullable ResizeOptions resizeOptions) {
        this.mResizeOptions = resizeOptions;
        return this;
    }

    @Nullable
    public ResizeOptions getResizeOptions() {
        return this.mResizeOptions;
    }

    public ImageRequestBuilder setRotationOptions(@Nullable RotationOptions rotationOptions) {
        this.mRotationOptions = rotationOptions;
        return this;
    }

    @Nullable
    public RotationOptions getRotationOptions() {
        return this.mRotationOptions;
    }

    public ImageRequestBuilder setBytesRange(@Nullable BytesRange bytesRange) {
        this.mBytesRange = bytesRange;
        return this;
    }

    @Nullable
    public BytesRange getBytesRange() {
        return this.mBytesRange;
    }

    public ImageRequestBuilder setImageDecodeOptions(ImageDecodeOptions imageDecodeOptions) {
        this.mImageDecodeOptions = imageDecodeOptions;
        return this;
    }

    public ImageDecodeOptions getImageDecodeOptions() {
        return this.mImageDecodeOptions;
    }

    public ImageRequestBuilder setCacheChoice(ImageRequest.CacheChoice cacheChoice) {
        this.mCacheChoice = cacheChoice;
        return this;
    }

    public ImageRequest.CacheChoice getCacheChoice() {
        return this.mCacheChoice;
    }

    public ImageRequestBuilder setProgressiveRenderingEnabled(boolean enabled) {
        this.mProgressiveRenderingEnabled = enabled;
        return this;
    }

    public boolean isProgressiveRenderingEnabled() {
        return this.mProgressiveRenderingEnabled;
    }

    public ImageRequestBuilder setLocalThumbnailPreviewsEnabled(boolean enabled) {
        this.mLocalThumbnailPreviewsEnabled = enabled;
        return this;
    }

    public boolean isLocalThumbnailPreviewsEnabled() {
        return this.mLocalThumbnailPreviewsEnabled;
    }

    public ImageRequestBuilder setLoadThumbnailOnly(boolean loadThumbnailOnly) {
        this.mLoadThumbnailOnly = loadThumbnailOnly;
        return this;
    }

    public boolean getLoadThumbnailOnly() {
        return this.mLoadThumbnailOnly;
    }

    public ImageRequestBuilder disableDiskCache() {
        int mask = 48;
        this.mCachesDisabled |= mask;
        return this;
    }

    public static boolean isCustomNetworkUri(@Nullable Uri uri) {
        if (CUSTOM_NETWORK_SCHEMES == null || uri == null) {
            return false;
        }
        for (String scheme : CUSTOM_NETWORK_SCHEMES) {
            if (!scheme.equals(uri.getScheme())) continue;
            return true;
        }
        return false;
    }

    public boolean isDiskCacheEnabled() {
        int mask = 48;
        return (this.mCachesDisabled & mask) == 0 && (UriUtil.isNetworkUri((Uri)this.mSourceUri) || ImageRequestBuilder.isCustomNetworkUri(this.mSourceUri));
    }

    public ImageRequestBuilder disableMemoryCache() {
        int mask = 15;
        this.mCachesDisabled |= mask;
        return this;
    }

    public boolean isMemoryCacheEnabled() {
        int mask = 15;
        return (this.mCachesDisabled & mask) == 0;
    }

    public ImageRequestBuilder setRequestPriority(Priority requestPriority) {
        this.mRequestPriority = requestPriority;
        return this;
    }

    public Priority getRequestPriority() {
        return this.mRequestPriority;
    }

    public ImageRequestBuilder setPostprocessor(@Nullable Postprocessor postprocessor) {
        this.mPostprocessor = postprocessor;
        return this;
    }

    @Nullable
    public Postprocessor getPostprocessor() {
        return this.mPostprocessor;
    }

    public ImageRequestBuilder setRequestListener(@Nullable RequestListener requestListener) {
        this.mRequestListener = requestListener;
        return this;
    }

    @Nullable
    public RequestListener getRequestListener() {
        return this.mRequestListener;
    }

    public ImageRequestBuilder setDiskCacheId(@Nullable String diskCacheId) {
        this.mDiskCacheId = diskCacheId;
        return this;
    }

    @Nullable
    public String getDiskCacheId() {
        return this.mDiskCacheId;
    }

    public ImageRequest build() {
        this.validate();
        return new ImageRequest(this);
    }

    @Nullable
    public Boolean shouldDecodePrefetches() {
        return this.mDecodePrefetches;
    }

    public ImageRequestBuilder setShouldDecodePrefetches(@Nullable Boolean shouldDecodePrefetches) {
        this.mDecodePrefetches = shouldDecodePrefetches;
        return this;
    }

    public ImageRequestBuilder setResizingAllowedOverride(@Nullable Boolean resizingAllowedOverride) {
        this.mResizingAllowedOverride = resizingAllowedOverride;
        return this;
    }

    @Nullable
    public Boolean getResizingAllowedOverride() {
        return this.mResizingAllowedOverride;
    }

    public int getDelayMs() {
        return this.mDelayMs;
    }

    public ImageRequestBuilder setDelayMs(int delayMs) {
        this.mDelayMs = delayMs;
        return this;
    }

    protected void validate() {
        if (this.mSourceUri == null) {
            throw new BuilderException("Source must be set!");
        }
        if (UriUtil.isLocalResourceUri((Uri)this.mSourceUri)) {
            if (!this.mSourceUri.isAbsolute()) {
                throw new BuilderException("Resource URI path must be absolute.");
            }
            if (this.mSourceUri.getPath().isEmpty()) {
                throw new BuilderException("Resource URI must not be empty");
            }
            try {
                Integer.parseInt(this.mSourceUri.getPath().substring(1));
            }
            catch (NumberFormatException ignored) {
                throw new BuilderException("Resource URI path must be a resource id.");
            }
        }
        if (UriUtil.isLocalAssetUri((Uri)this.mSourceUri) && !this.mSourceUri.isAbsolute()) {
            throw new BuilderException("Asset URI path must be absolute.");
        }
        if (this.mCacheChoice == ImageRequest.CacheChoice.DYNAMIC) {
            if (this.mDiskCacheId == null) {
                throw new BuilderException("Disk cache id must be set for dynamic cache choice");
            }
        } else if (this.mDiskCacheId != null && this.mDiskCacheId.length() != 0) {
            throw new BuilderException("Ensure that if you want to use a disk cache id, you set the CacheChoice to DYNAMIC");
        }
    }

    public static class BuilderException
    extends RuntimeException {
        public BuilderException(String message) {
            super("Invalid request builder: " + message);
        }
    }
}

