/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.transcoder;

import com.facebook.imageformat.ImageFormat;
import com.facebook.imagepipeline.core.NativeCodeSetup;
import com.facebook.imagepipeline.nativecode.NativeImageTranscoderFactory;
import com.facebook.imagepipeline.transcoder.ImageTranscoder;
import com.facebook.imagepipeline.transcoder.ImageTranscoderFactory;
import com.facebook.imagepipeline.transcoder.SimpleImageTranscoderFactory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/facebook/imagepipeline/transcoder/MultiImageTranscoderFactory;", "Lcom/facebook/imagepipeline/transcoder/ImageTranscoderFactory;", "maxBitmapSize", "", "useDownSamplingRatio", "", "primaryImageTranscoderFactory", "imageTranscoderType", "ensureTranscoderLibraryLoaded", "<init>", "(IZLcom/facebook/imagepipeline/transcoder/ImageTranscoderFactory;Ljava/lang/Integer;Z)V", "Ljava/lang/Integer;", "createImageTranscoder", "Lcom/facebook/imagepipeline/transcoder/ImageTranscoder;", "imageFormat", "Lcom/facebook/imageformat/ImageFormat;", "isResizingEnabled", "getCustomImageTranscoder", "getNativeImageTranscoder", "getSimpleImageTranscoder", "getImageTranscoderWithType", "imagepipeline_release"})
public final class MultiImageTranscoderFactory
implements ImageTranscoderFactory {
    private final int maxBitmapSize;
    private final boolean useDownSamplingRatio;
    @Nullable
    private final ImageTranscoderFactory primaryImageTranscoderFactory;
    @Nullable
    private final Integer imageTranscoderType;
    private final boolean ensureTranscoderLibraryLoaded;

    public MultiImageTranscoderFactory(int maxBitmapSize, boolean useDownSamplingRatio, @Nullable ImageTranscoderFactory primaryImageTranscoderFactory, @Nullable Integer imageTranscoderType, boolean ensureTranscoderLibraryLoaded) {
        this.maxBitmapSize = maxBitmapSize;
        this.useDownSamplingRatio = useDownSamplingRatio;
        this.primaryImageTranscoderFactory = primaryImageTranscoderFactory;
        this.imageTranscoderType = imageTranscoderType;
        this.ensureTranscoderLibraryLoaded = ensureTranscoderLibraryLoaded;
    }

    @NotNull
    public ImageTranscoder createImageTranscoder(@NotNull ImageFormat imageFormat, boolean isResizingEnabled) {
        ImageTranscoder imageTranscoder;
        Intrinsics.checkNotNullParameter((Object)imageFormat, (String)"imageFormat");
        ImageTranscoder imageTranscoder2 = this.getCustomImageTranscoder(imageFormat, isResizingEnabled);
        if (imageTranscoder2 == null) {
            imageTranscoder2 = this.getImageTranscoderWithType(imageFormat, isResizingEnabled);
        }
        if (imageTranscoder2 == null && NativeCodeSetup.getUseNativeCode()) {
            imageTranscoder2 = this.getNativeImageTranscoder(imageFormat, isResizingEnabled);
        }
        if ((imageTranscoder = imageTranscoder2) == null) {
            imageTranscoder = this.getSimpleImageTranscoder(imageFormat, isResizingEnabled);
        }
        return imageTranscoder;
    }

    private final ImageTranscoder getCustomImageTranscoder(ImageFormat imageFormat, boolean isResizingEnabled) {
        ImageTranscoderFactory imageTranscoderFactory = this.primaryImageTranscoderFactory;
        return imageTranscoderFactory != null ? imageTranscoderFactory.createImageTranscoder(imageFormat, isResizingEnabled) : null;
    }

    private final ImageTranscoder getNativeImageTranscoder(ImageFormat imageFormat, boolean isResizingEnabled) {
        return NativeImageTranscoderFactory.getNativeImageTranscoderFactory((int)this.maxBitmapSize, (boolean)this.useDownSamplingRatio, (boolean)this.ensureTranscoderLibraryLoaded).createImageTranscoder(imageFormat, isResizingEnabled);
    }

    private final ImageTranscoder getSimpleImageTranscoder(ImageFormat imageFormat, boolean isResizingEnabled) {
        ImageTranscoder imageTranscoder = new SimpleImageTranscoderFactory(this.maxBitmapSize).createImageTranscoder(imageFormat, isResizingEnabled);
        Intrinsics.checkNotNullExpressionValue((Object)imageTranscoder, (String)"createImageTranscoder(...)");
        return imageTranscoder;
    }

    private final ImageTranscoder getImageTranscoderWithType(ImageFormat imageFormat, boolean isResizingEnabled) {
        ImageTranscoder imageTranscoder;
        if (this.imageTranscoderType == null) {
            imageTranscoder = null;
        } else {
            Integer n;
            Integer n2 = n = this.imageTranscoderType;
            if (n2 != null && n2 == 0) {
                imageTranscoder = this.getNativeImageTranscoder(imageFormat, isResizingEnabled);
            } else {
                Integer n3 = n;
                int n4 = 1;
                if (n3 != null && n3 == n4) {
                    imageTranscoder = this.getSimpleImageTranscoder(imageFormat, isResizingEnabled);
                } else {
                    throw new IllegalArgumentException("Invalid ImageTranscoderType");
                }
            }
        }
        return imageTranscoder;
    }
}

