/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.memory;

import android.util.SparseIntArray;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.memory.MemoryTrimmableRegistry;
import com.facebook.imagepipeline.memory.BasePool;
import com.facebook.imagepipeline.memory.MemoryChunk;
import com.facebook.imagepipeline.memory.PoolParams;
import com.facebook.imagepipeline.memory.PoolStatsTracker;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.concurrent.ThreadSafe;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
@ThreadSafe
public abstract class MemoryChunkPool
extends BasePool<MemoryChunk> {
    private final int[] mBucketSizes;

    MemoryChunkPool(MemoryTrimmableRegistry memoryTrimmableRegistry, PoolParams poolParams, PoolStatsTracker memoryChunkPoolStatsTracker) {
        super(memoryTrimmableRegistry, poolParams, memoryChunkPoolStatsTracker);
        SparseIntArray bucketSizes = (SparseIntArray)Preconditions.checkNotNull((Object)poolParams.bucketSizes);
        this.mBucketSizes = new int[bucketSizes.size()];
        for (int i = 0; i < this.mBucketSizes.length; ++i) {
            this.mBucketSizes[i] = bucketSizes.keyAt(i);
        }
        this.initialize();
    }

    int getMinBufferSize() {
        return this.mBucketSizes[0];
    }

    @Override
    protected abstract MemoryChunk alloc(int var1);

    @Override
    protected void free(MemoryChunk value) {
        Preconditions.checkNotNull((Object)value);
        value.close();
    }

    @Override
    protected int getSizeInBytes(int bucketedSize) {
        return bucketedSize;
    }

    @Override
    protected int getBucketedSize(int requestSize) {
        if (requestSize <= 0) {
            throw new BasePool.InvalidSizeException(requestSize);
        }
        for (int bucketedSize : this.mBucketSizes) {
            if (bucketedSize < requestSize) continue;
            return bucketedSize;
        }
        return requestSize;
    }

    @Override
    protected int getBucketedSizeForValue(MemoryChunk value) {
        Preconditions.checkNotNull((Object)value);
        return value.getSize();
    }

    @Override
    protected boolean isReusable(MemoryChunk value) {
        Preconditions.checkNotNull((Object)value);
        return !value.isClosed();
    }
}

