/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import com.facebook.hive.orc.InStream;
import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.RunLengthByteReader;
import java.io.EOFException;
import java.io.IOException;
import java.util.List;

public class BitFieldReader {
    private final RunLengthByteReader input;
    private int current;
    private int bitsLeft;
    private int[] indeces;

    public BitFieldReader(InStream input) throws IOException {
        this.input = new RunLengthByteReader(input);
    }

    private void readByte() throws IOException {
        if (!this.input.hasNext()) {
            throw new EOFException("Read past end of bit field from " + this.input);
        }
        this.current = 0xFF & this.input.next();
        this.bitsLeft = 8;
    }

    public int next() throws IOException {
        int result = 0;
        if (this.bitsLeft == 0) {
            this.readByte();
        }
        --this.bitsLeft;
        return (result |= this.current >>> this.bitsLeft & 1) & 1;
    }

    public void seek(int index) throws IOException {
        this.input.seek(index);
        int consumed = this.indeces[index];
        if (consumed > 8) {
            throw new IllegalArgumentException("Seek past end of byte at " + consumed + " in " + this.input);
        }
        if (consumed != 0) {
            this.readByte();
            this.bitsLeft = 8 - consumed;
        } else {
            this.bitsLeft = 0;
        }
    }

    public int loadIndeces(List<OrcProto.RowIndexEntry> rowIndexEntries, int startIndex) {
        int updatedStartIndex = this.input.loadIndeces(rowIndexEntries, startIndex);
        int numIndeces = rowIndexEntries.size();
        this.indeces = new int[numIndeces + 1];
        int i = 0;
        for (OrcProto.RowIndexEntry rowIndexEntry : rowIndexEntries) {
            this.indeces[i] = (int)rowIndexEntry.getPositions(updatedStartIndex);
            ++i;
        }
        return updatedStartIndex + 1;
    }

    public void skip(long items) throws IOException {
        long totalBits = items;
        if ((long)this.bitsLeft >= totalBits) {
            this.bitsLeft = (int)((long)this.bitsLeft - totalBits);
        } else {
            this.input.skip((totalBits -= (long)this.bitsLeft) / 8L);
            this.bitsLeft = (int)(8L - totalBits % 8L);
            if (this.input.hasNext()) {
                this.current = this.input.next();
            } else {
                this.bitsLeft = 0;
            }
        }
    }

    public void close() throws IOException {
        this.input.close();
    }
}

