/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc;

import com.facebook.hive.orc.InStream;
import com.facebook.hive.orc.OrcProto;
import java.io.EOFException;
import java.io.IOException;
import java.util.List;

public class RunLengthByteReader {
    private final InStream input;
    private final byte[] literals = new byte[128];
    private int numLiterals = 0;
    private int used = 0;
    private boolean repeat = false;
    private int[] indeces;

    public RunLengthByteReader(InStream input) throws IOException {
        this.input = input;
    }

    private void readValues() throws IOException {
        int control = this.input.read();
        this.used = 0;
        if (control == -1) {
            throw new EOFException("Read past end of buffer RLE byte from " + this.input);
        }
        if (control < 128) {
            this.repeat = true;
            this.numLiterals = control + 3;
            int val = this.input.read();
            if (val == -1) {
                throw new EOFException("Reading RLE byte got EOF");
            }
            this.literals[0] = (byte)val;
        } else {
            int result;
            this.repeat = false;
            this.numLiterals = 256 - control;
            for (int bytes = 0; bytes < this.numLiterals; bytes += result) {
                result = this.input.read(this.literals, bytes, this.numLiterals - bytes);
                if (result != -1) continue;
                throw new EOFException("Reading RLE byte literal got EOF");
            }
        }
    }

    boolean hasNext() throws IOException {
        return this.used != this.numLiterals || this.input.available() > 0;
    }

    public byte next() throws IOException {
        byte result;
        if (this.used == this.numLiterals) {
            this.readValues();
        }
        if (this.repeat) {
            ++this.used;
            result = this.literals[0];
        } else {
            result = this.literals[this.used++];
        }
        return result;
    }

    public void seek(int index) throws IOException {
        int consumed;
        this.input.seek(index);
        if (consumed != 0) {
            for (consumed = this.indeces[index]; consumed > 0; consumed -= this.numLiterals) {
                this.readValues();
                this.used = consumed;
            }
        } else {
            this.used = 0;
            this.numLiterals = 0;
        }
    }

    public int loadIndeces(List<OrcProto.RowIndexEntry> rowIndexEntries, int startIndex) {
        int updatedStartIndex = this.input.loadIndeces(rowIndexEntries, startIndex);
        int numIndeces = rowIndexEntries.size();
        this.indeces = new int[numIndeces + 1];
        int i = 0;
        for (OrcProto.RowIndexEntry rowIndexEntry : rowIndexEntries) {
            this.indeces[i] = (int)rowIndexEntry.getPositions(updatedStartIndex);
            ++i;
        }
        return updatedStartIndex + 1;
    }

    public void skip(long items) throws IOException {
        while (items > 0L) {
            if (this.used == this.numLiterals) {
                this.readValues();
            }
            long consume = Math.min(items, (long)(this.numLiterals - this.used));
            this.used = (int)((long)this.used + consume);
            items -= consume;
        }
    }

    public void close() throws IOException {
        this.input.close();
    }
}

