/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc.lazy;

import com.facebook.hive.orc.BitFieldReader;
import com.facebook.hive.orc.InStream;
import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.StreamName;
import com.facebook.hive.orc.lazy.LazyTreeReader;
import com.facebook.hive.orc.lazy.OrcLazyObject;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.io.BooleanWritable;

public class LazyBooleanTreeReader
extends LazyTreeReader {
    private BitFieldReader reader = null;
    private boolean latestRead = true;

    public LazyBooleanTreeReader(int columnId, long rowIndexStride) {
        super(columnId, rowIndexStride);
    }

    @Override
    public void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings, OrcProto.RowIndex[] indexes, long rowBaseInStripe) throws IOException {
        super.startStripe(streams, encodings, indexes, rowBaseInStripe);
        this.reader = new BitFieldReader(streams.get(new StreamName(this.columnId, OrcProto.Stream.Kind.DATA)));
        if (indexes[this.columnId] != null) {
            this.loadIndeces(indexes[this.columnId].getEntryList(), 0);
        }
    }

    @Override
    public void seek(int index) throws IOException {
        this.reader.seek(index);
    }

    @Override
    public int loadIndeces(List<OrcProto.RowIndexEntry> rowIndexEntries, int startIndex) {
        int updatedStartIndex = super.loadIndeces(rowIndexEntries, startIndex);
        return this.reader.loadIndeces(rowIndexEntries, updatedStartIndex);
    }

    @Override
    public void skipRows(long numNonNullValues) throws IOException {
        this.reader.skip(numNonNullValues);
    }

    boolean readBoolean() throws IOException {
        this.latestRead = this.reader.next() == 1;
        return this.latestRead;
    }

    BooleanWritable createWritable(Object previous, boolean v) throws IOException {
        BooleanWritable result = null;
        result = previous == null ? new BooleanWritable() : (BooleanWritable)previous;
        result.set(v);
        return result;
    }

    @Override
    public Object createWritableFromLatest(Object previous) throws IOException {
        return this.createWritable(previous, this.latestRead);
    }

    @Override
    public boolean nextBoolean(boolean readStream) throws IOException {
        if (!readStream) {
            return this.latestRead;
        }
        if (!this.valuePresent) {
            throw new OrcLazyObject.ValueNotPresentException("Cannot materialize boolean.");
        }
        return this.readBoolean();
    }

    @Override
    public Object next(Object previous) throws IOException {
        BooleanWritable result = null;
        if (this.valuePresent) {
            result = this.createWritable(previous, this.readBoolean());
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

