/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc.lazy;

import com.facebook.hive.orc.InStream;
import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.StreamName;
import com.facebook.hive.orc.lazy.LazyIntDictionaryTreeReader;
import com.facebook.hive.orc.lazy.LazyIntDirectTreeReader;
import com.facebook.hive.orc.lazy.LazyTreeReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class LazyIntTreeReader
extends LazyTreeReader {
    protected LazyTreeReader reader;

    public LazyIntTreeReader(int columnId, long rowIndexStride) {
        super(columnId, rowIndexStride);
    }

    @Override
    public void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings, OrcProto.RowIndex[] indexes, long rowBaseInStripe) throws IOException {
        switch (encodings.get(this.columnId).getKind()) {
            case DICTIONARY: {
                this.reader = new LazyIntDictionaryTreeReader(this.columnId, this.rowIndexStride);
                break;
            }
            case DIRECT: {
                this.reader = new LazyIntDirectTreeReader(this.columnId, this.rowIndexStride);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported encoding " + encodings.get(this.columnId).getKind());
            }
        }
        this.reader.startStripe(streams, encodings, indexes, rowBaseInStripe);
        if (indexes[this.columnId] != null) {
            this.loadIndeces(indexes[this.columnId].getEntryList(), 0);
        }
    }

    @Override
    public void seek(int index) throws IOException {
        this.reader.seek(index);
    }

    @Override
    public int loadIndeces(List<OrcProto.RowIndexEntry> rowIndexEntries, int startIndex) {
        return this.reader.loadIndeces(rowIndexEntries, startIndex);
    }

    @Override
    protected void seek(int rowIndexEntry, boolean backwards) throws IOException {
        this.reader.seek(rowIndexEntry, backwards);
    }

    @Override
    public boolean nextIsNull(long currentRow) throws IOException {
        return this.reader.nextIsNull(currentRow);
    }

    @Override
    public boolean nextIsNullInComplexType() throws IOException {
        return this.reader.nextIsNullInComplexType();
    }

    @Override
    public Object getInComplexType(Object previous, long row) throws IOException {
        return this.reader.getInComplexType(previous, row);
    }

    @Override
    public Object get(long currentRow, Object previous) throws IOException {
        return this.reader.get(currentRow, previous);
    }

    @Override
    public boolean getBoolean(long currentRow) throws IOException {
        return this.reader.getBoolean(currentRow);
    }

    @Override
    public long getLong(long currentRow) throws IOException {
        return this.reader.getLong(currentRow);
    }

    @Override
    public int getInt(long currentRow) throws IOException {
        return this.reader.getInt(currentRow);
    }

    @Override
    public short getShort(long currentRow) throws IOException {
        return this.reader.getShort(currentRow);
    }

    @Override
    public double getDouble(long currentRow) throws IOException {
        return this.reader.getDouble(currentRow);
    }

    @Override
    public float getFloat(long currentRow) throws IOException {
        return this.reader.getFloat(currentRow);
    }

    @Override
    public Object next(Object previous) throws IOException {
        return this.reader.next(previous);
    }

    @Override
    public void skipRowsInComplexType(long numRows) throws IOException {
        this.reader.skipRowsInComplexType(numRows);
    }

    @Override
    public void skipRows(long numNonNullValues) throws IOException {
        this.reader.skipRows(numNonNullValues);
    }

    @Override
    public Object createWritableFromLatest(Object previous) throws IOException {
        return this.reader.createWritableFromLatest(previous);
    }

    @Override
    public boolean nextBoolean(boolean readStream) throws IOException {
        return this.reader.nextBoolean(readStream);
    }

    @Override
    public short nextShort(boolean readStream) throws IOException {
        return this.reader.nextShort(readStream);
    }

    @Override
    public int nextInt(boolean readStream) throws IOException {
        return this.reader.nextInt(readStream);
    }

    @Override
    public long nextLong(boolean readStream) throws IOException {
        return this.reader.nextLong(readStream);
    }

    @Override
    public float nextFloat(boolean readStream) throws IOException {
        return this.reader.nextFloat(readStream);
    }

    @Override
    public double nextDouble(boolean readStream) throws IOException {
        return this.reader.nextDouble(readStream);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.reader != null) {
            this.reader.close();
        }
    }
}

