/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc.lazy;

import com.facebook.hive.orc.InStream;
import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.StreamName;
import com.facebook.hive.orc.lazy.LazyTreeReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.io.Writable;

public abstract class OrcLazyObject
implements Writable {
    private long currentRow = 0L;
    private final LazyTreeReader treeReader;
    protected Object previous;
    private boolean nextIsNull;
    private boolean materialized;
    private boolean writableCreated = false;
    private boolean nextIsNullSet = false;
    protected static final Materializer doubleMaker = new Materializer(){

        @Override
        public void materialize(LazyTreeReader treeReader, long currentRow) throws IOException {
            treeReader.getDouble(currentRow);
        }
    };
    protected static final Materializer floatMaker = new Materializer(){

        @Override
        public void materialize(LazyTreeReader treeReader, long currentRow) throws IOException {
            treeReader.getFloat(currentRow);
        }
    };
    protected static final Materializer booleanMaker = new Materializer(){

        @Override
        public void materialize(LazyTreeReader treeReader, long currentRow) throws IOException {
            treeReader.getBoolean(currentRow);
        }
    };
    protected static final Materializer longMaker = new Materializer(){

        @Override
        public void materialize(LazyTreeReader treeReader, long currentRow) throws IOException {
            treeReader.getLong(currentRow);
        }
    };
    protected static final Materializer intMaker = new Materializer(){

        @Override
        public void materialize(LazyTreeReader treeReader, long currentRow) throws IOException {
            treeReader.getInt(currentRow);
        }
    };
    protected static final Materializer shortMaker = new Materializer(){

        @Override
        public void materialize(LazyTreeReader treeReader, long currentRow) throws IOException {
            treeReader.getShort(currentRow);
        }
    };

    public OrcLazyObject(LazyTreeReader treeReader) {
        this.treeReader = treeReader;
    }

    public OrcLazyObject(OrcLazyObject copy) {
        this.materialized = copy.materialized;
        this.writableCreated = copy.writableCreated;
        this.currentRow = copy.currentRow;
        this.nextIsNull = copy.nextIsNull;
        this.nextIsNullSet = copy.nextIsNullSet;
        this.previous = copy.previous;
        this.treeReader = copy.treeReader;
    }

    public void write(DataOutput dataOutput) throws IOException {
        throw new UnsupportedOperationException("write unsupported");
    }

    public void readFields(DataInput dataInput) throws IOException {
        throw new UnsupportedOperationException("readFields unsupported");
    }

    public LazyTreeReader getLazyTreeReader() {
        return this.treeReader;
    }

    public Object materialize() throws IOException {
        if (!this.materialized) {
            this.previous = this.materialize(this.currentRow, this.previous);
            this.materialized = true;
            this.writableCreated = true;
            this.nextIsNull = this.previous == null;
            this.nextIsNullSet = true;
        } else if (this.nextIsNull) {
            return null;
        }
        if (!this.writableCreated) {
            this.previous = this.treeReader.createWritableFromLatest(this.previous);
            this.writableCreated = true;
        }
        return this.previous;
    }

    protected Object materialize(long row, Object previous) throws IOException {
        return this.treeReader.get(row, previous);
    }

    public void materializeHelper(Materializer maker) throws IOException {
        if (!this.materialized) {
            try {
                maker.materialize(this.treeReader, this.currentRow);
                this.materialized = true;
                this.writableCreated = false;
                this.nextIsNull = false;
                this.nextIsNullSet = true;
            }
            catch (ValueNotPresentException e) {
                this.materialized = true;
                this.writableCreated = true;
                this.nextIsNull = true;
                this.nextIsNullSet = true;
                throw new IOException("Cannot materialize primitive: value not present");
            }
        } else if (this.nextIsNull) {
            throw new IOException("Cannot materialize primitive: value not present.");
        }
    }

    public double materializeDouble() throws IOException {
        this.materializeHelper(doubleMaker);
        return this.treeReader.nextDouble(false);
    }

    public float materializeFloat() throws IOException {
        this.materializeHelper(floatMaker);
        return this.treeReader.nextFloat(false);
    }

    public boolean materializeBoolean() throws IOException {
        this.materializeHelper(booleanMaker);
        return this.treeReader.nextBoolean(false);
    }

    public long materializeLong() throws IOException {
        this.materializeHelper(longMaker);
        return this.treeReader.nextLong(false);
    }

    public int materializeInt() throws IOException {
        this.materializeHelper(intMaker);
        return this.treeReader.nextInt(false);
    }

    public short materializeShort() throws IOException {
        this.materializeHelper(shortMaker);
        return this.treeReader.nextShort(false);
    }

    public void next() {
        ++this.currentRow;
        this.materialized = false;
        this.writableCreated = false;
        this.nextIsNullSet = false;
    }

    public boolean nextIsNull() throws IOException {
        if (!this.nextIsNullSet) {
            this.nextIsNull = this.treeReader.nextIsNull(this.currentRow);
            this.nextIsNullSet = true;
            this.materialized = this.nextIsNull;
            this.writableCreated = this.nextIsNull;
        }
        return this.nextIsNull;
    }

    public void startStripe(Map<StreamName, InStream> streams, List<OrcProto.ColumnEncoding> encodings, OrcProto.RowIndex[] indexes, long rowBaseInStripe) throws IOException {
        this.treeReader.startStripe(streams, encodings, indexes, rowBaseInStripe);
    }

    public void seekToRow(long rowNumber) throws IOException {
        this.currentRow = rowNumber;
    }

    public int hashCode() {
        try {
            this.materialize();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.nextIsNull ? 0 : this.previous.hashCode();
    }

    public void close() throws IOException {
        this.treeReader.close();
    }

    protected static interface Materializer {
        public void materialize(LazyTreeReader var1, long var2) throws IOException;
    }

    protected static final class ValueNotPresentException
    extends IOException {
        public ValueNotPresentException() {
        }

        public ValueNotPresentException(String message) {
            super(message);
        }
    }
}

