/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc.lazy;

import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.OrcStruct;
import com.facebook.hive.orc.lazy.OrcLazyObject;
import com.facebook.hive.orc.lazy.OrcLazyObjectInspectorUtils;
import com.facebook.hive.orc.lazy.OrcLazyRow;
import com.facebook.hive.orc.lazy.OrcLazyStructObjectInspector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class OrcLazyRowObjectInspector
extends OrcLazyStructObjectInspector {
    public OrcLazyRowObjectInspector(StructTypeInfo info) {
        ArrayList fieldNames = info.getAllStructFieldNames();
        ArrayList fieldTypes = info.getAllStructFieldTypeInfos();
        for (int i = 0; i < fieldNames.size(); ++i) {
            this.fields.add(new OrcStruct.Field((String)fieldNames.get(i), OrcLazyObjectInspectorUtils.createLazyObjectInspector((TypeInfo)fieldTypes.get(i)), i));
        }
    }

    public OrcLazyRowObjectInspector(int columnId, List<OrcProto.Type> types) {
        OrcProto.Type type = types.get(columnId);
        int fieldCount = type.getSubtypesCount();
        for (int i = 0; i < fieldCount; ++i) {
            int fieldType = type.getSubtypes(i);
            this.fields.add(new OrcStruct.Field(type.getFieldNames(i), OrcLazyObjectInspectorUtils.createLazyObjectInspector(fieldType, types), i));
        }
    }

    @Override
    public Object getStructFieldData(Object data, StructField fieldRef) {
        int offset = ((OrcStruct.Field)fieldRef).getOffset();
        try {
            OrcLazyObject obj = ((OrcLazyRow)data).getFieldValue(offset);
            if (obj != null) {
                obj.materialize();
                return obj.nextIsNull() ? null : obj;
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public StructField getStructFieldRef(String fieldName) {
        for (StructField field : this.fields) {
            if (!field.getFieldName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    @Override
    public List<Object> getStructFieldsDataAsList(Object data) {
        OrcLazyRow row = (OrcLazyRow)data;
        int numFields = row.getNumFields();
        ArrayList<Object> result = new ArrayList<Object>(numFields);
        for (int i = 0; i < numFields; ++i) {
            try {
                OrcLazyObject obj = row.getFieldValue(i);
                result.add(obj == null || obj.nextIsNull() ? null : obj);
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }
}

