/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc.lazy;

import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.OrcStruct;
import com.facebook.hive.orc.lazy.OrcLazyObjectInspectorUtils;
import com.facebook.hive.orc.lazy.OrcLazyStruct;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class OrcLazyStructObjectInspector
extends StructObjectInspector {
    protected final List<StructField> fields;

    protected OrcLazyStructObjectInspector() {
        this.fields = new ArrayList<StructField>();
    }

    public OrcLazyStructObjectInspector(StructTypeInfo info) {
        ArrayList fieldNames = info.getAllStructFieldNames();
        ArrayList fieldTypes = info.getAllStructFieldTypeInfos();
        this.fields = new ArrayList<StructField>(fieldNames.size());
        for (int i = 0; i < fieldNames.size(); ++i) {
            this.fields.add(new OrcStruct.Field((String)fieldNames.get(i), OrcLazyObjectInspectorUtils.createWritableObjectInspector((TypeInfo)fieldTypes.get(i)), i));
        }
    }

    public OrcLazyStructObjectInspector(int columnId, List<OrcProto.Type> types) {
        OrcProto.Type type = types.get(columnId);
        int fieldCount = type.getSubtypesCount();
        this.fields = new ArrayList<StructField>(fieldCount);
        for (int i = 0; i < fieldCount; ++i) {
            int fieldType = type.getSubtypes(i);
            this.fields.add(new OrcStruct.Field(type.getFieldNames(i), OrcLazyObjectInspectorUtils.createWritableObjectInspector(fieldType, types), i));
        }
    }

    public List<? extends StructField> getAllStructFieldRefs() {
        return this.fields;
    }

    public Object getStructFieldData(Object data, StructField fieldRef) {
        OrcStruct struct;
        if (data == null) {
            return null;
        }
        int offset = ((OrcStruct.Field)fieldRef).getOffset();
        try {
            struct = (OrcStruct)((OrcLazyStruct)data).materialize();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (offset >= struct.getNumFields()) {
            return null;
        }
        return struct.getFieldValue(offset);
    }

    public StructField getStructFieldRef(String fieldName) {
        for (StructField field : this.fields) {
            if (!field.getFieldName().equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    public List<Object> getStructFieldsDataAsList(Object data) {
        OrcStruct struct;
        if (data == null) {
            return null;
        }
        try {
            struct = (OrcStruct)((OrcLazyStruct)data).materialize();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ArrayList<Object> result = new ArrayList<Object>(struct.getNumFields());
        for (int i = 0; i < struct.getNumFields(); ++i) {
            result.add(struct.getFieldValue(i));
        }
        return result;
    }

    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.STRUCT;
    }

    public String getTypeName() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("struct<");
        for (int i = 0; i < this.fields.size(); ++i) {
            StructField field = this.fields.get(i);
            if (i != 0) {
                buffer.append(",");
            }
            buffer.append(field.getFieldName());
            buffer.append(":");
            buffer.append(field.getFieldObjectInspector().getTypeName());
        }
        buffer.append(">");
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        if (o == this) {
            return true;
        }
        List<StructField> other = ((OrcLazyStructObjectInspector)((Object)o)).fields;
        if (other.size() != this.fields.size()) {
            return false;
        }
        for (int i = 0; i < this.fields.size(); ++i) {
            StructField left = other.get(i);
            StructField right = this.fields.get(i);
            if (left.getFieldName().equals(right.getFieldName()) && left.getFieldObjectInspector().equals(right.getFieldObjectInspector())) continue;
            return false;
        }
        return true;
    }
}

