/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hive.orc.lazy;

import com.facebook.hive.orc.OrcProto;
import com.facebook.hive.orc.OrcUnion;
import com.facebook.hive.orc.lazy.OrcLazyObjectInspectorUtils;
import com.facebook.hive.orc.lazy.OrcLazyUnion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;

public class OrcLazyUnionObjectInspector
implements UnionObjectInspector {
    private final List<ObjectInspector> children;

    public OrcLazyUnionObjectInspector(int columnId, List<OrcProto.Type> types) {
        OrcProto.Type type = types.get(columnId);
        this.children = new ArrayList<ObjectInspector>(type.getSubtypesCount());
        for (int i = 0; i < type.getSubtypesCount(); ++i) {
            this.children.add(OrcLazyObjectInspectorUtils.createWritableObjectInspector(type.getSubtypes(i), types));
        }
    }

    public OrcLazyUnionObjectInspector(UnionTypeInfo info) {
        List unionChildren = info.getAllUnionObjectTypeInfos();
        this.children = new ArrayList<ObjectInspector>(unionChildren.size());
        for (TypeInfo child : info.getAllUnionObjectTypeInfos()) {
            this.children.add(OrcLazyObjectInspectorUtils.createWritableObjectInspector(child));
        }
    }

    private OrcUnion get(Object o) {
        if (o == null) {
            return null;
        }
        try {
            return (OrcUnion)((OrcLazyUnion)o).materialize();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Object getField(Object o) {
        if (o == null) {
            return null;
        }
        return this.get(o).getObject();
    }

    public List<ObjectInspector> getObjectInspectors() {
        return this.children;
    }

    public byte getTag(Object o) {
        if (o == null) {
            return -1;
        }
        return this.get(o).getTag();
    }

    public ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.UNION;
    }

    public String getTypeName() {
        StringBuilder builder = new StringBuilder("uniontype<");
        boolean first = true;
        for (ObjectInspector child : this.children) {
            if (first) {
                first = false;
            } else {
                builder.append(",");
            }
            builder.append(child.getTypeName());
        }
        builder.append(">");
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        if (o == this) {
            return true;
        }
        List<ObjectInspector> other = ((OrcLazyUnionObjectInspector)o).children;
        if (other.size() != this.children.size()) {
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (other.get(i).equals(this.children.get(i))) continue;
            return false;
        }
        return true;
    }
}

