/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.block;

import com.facebook.presto.common.block.AbstractArrayBlock;
import com.facebook.presto.common.block.ArrayBlock;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockBuilderStatus;
import com.facebook.presto.common.block.BlockUtil;
import com.facebook.presto.common.block.SingleArrayBlockWriter;
import com.facebook.presto.common.type.Type;
import io.airlift.slice.SizeOf;
import io.airlift.slice.SliceInput;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import org.openjdk.jol.info.ClassLayout;

public class ArrayBlockBuilder
extends AbstractArrayBlock
implements BlockBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ArrayBlockBuilder.class).instanceSize();
    private int positionCount;
    @Nullable
    private final BlockBuilderStatus blockBuilderStatus;
    private final int initialEntryCount;
    private boolean initialized;
    private int[] offsets = new int[1];
    private boolean[] valueIsNull = new boolean[0];
    private boolean hasNullValue;
    private final BlockBuilder values;
    private boolean currentEntryOpened;
    private long retainedSizeInBytes;

    public ArrayBlockBuilder(BlockBuilder valuesBlock, BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        this(blockBuilderStatus, valuesBlock, expectedEntries);
    }

    public ArrayBlockBuilder(Type elementType, BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        this(blockBuilderStatus, elementType.createBlockBuilder(blockBuilderStatus, expectedEntries, expectedBytesPerEntry), expectedEntries);
    }

    public ArrayBlockBuilder(Type elementType, BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        this(blockBuilderStatus, elementType.createBlockBuilder(blockBuilderStatus, expectedEntries), expectedEntries);
    }

    private ArrayBlockBuilder(@Nullable BlockBuilderStatus blockBuilderStatus, BlockBuilder values, int expectedEntries) {
        this.blockBuilderStatus = blockBuilderStatus;
        this.values = Objects.requireNonNull(values, "values is null");
        this.initialEntryCount = Math.max(expectedEntries, 1);
        this.updateDataSize();
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        return this.values.getSizeInBytes() + 5L * (long)this.positionCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes + this.values.getRetainedSizeInBytes();
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        consumer.accept(this.values, this.values.getRetainedSizeInBytes());
        consumer.accept(this.offsets, SizeOf.sizeOf((int[])this.offsets));
        consumer.accept(this.valueIsNull, SizeOf.sizeOf((boolean[])this.valueIsNull));
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    protected Block getRawElementBlock() {
        return this.values;
    }

    @Override
    protected int[] getOffsets() {
        return this.offsets;
    }

    @Override
    public int getOffsetBase() {
        return 0;
    }

    @Override
    @Nullable
    protected boolean[] getValueIsNull() {
        return this.hasNullValue ? this.valueIsNull : null;
    }

    @Override
    public boolean mayHaveNull() {
        return this.hasNullValue;
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.hasNullValue && this.valueIsNull[position];
    }

    @Override
    public BlockBuilder appendStructure(Block block) {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Expected current entry to be closed but was opened");
        }
        this.currentEntryOpened = true;
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) {
                this.values.appendNull();
                continue;
            }
            block.writePositionTo(i, this.values);
        }
        this.closeEntry();
        return this;
    }

    @Override
    public Block getSingleValueBlock(int position) {
        return this.getSingleValueBlockInternal(position);
    }

    @Override
    public BlockBuilder appendStructureInternal(Block block, int position) {
        if (!(block instanceof AbstractArrayBlock)) {
            throw new IllegalArgumentException();
        }
        AbstractArrayBlock arrayBlock = (AbstractArrayBlock)block;
        SingleArrayBlockWriter entryBuilder = this.beginBlockEntry();
        int startValueOffset = arrayBlock.getOffset(position);
        int endValueOffset = arrayBlock.getOffset(position + 1);
        for (int i = startValueOffset; i < endValueOffset; ++i) {
            if (arrayBlock.getRawElementBlock().isNull(i)) {
                entryBuilder.appendNull();
                continue;
            }
            arrayBlock.getRawElementBlock().writePositionTo(i, entryBuilder);
        }
        this.closeEntry();
        return this;
    }

    public BlockBuilder getElementBlockBuilder() {
        return this.values;
    }

    @Override
    public void beginDirectEntry() {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Expected current entry to be closed but was opened");
        }
        this.currentEntryOpened = true;
    }

    @Override
    public SingleArrayBlockWriter beginBlockEntry() {
        this.beginDirectEntry();
        return new SingleArrayBlockWriter(this.values, this.values.getPositionCount());
    }

    @Override
    public BlockBuilder closeEntry() {
        if (!this.currentEntryOpened) {
            throw new IllegalStateException("Expected entry to be opened but was closed");
        }
        this.entryAdded(false);
        this.currentEntryOpened = false;
        return this;
    }

    @Override
    public BlockBuilder appendNull() {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Current entry must be closed before a null can be written");
        }
        this.entryAdded(true);
        return this;
    }

    private void entryAdded(boolean isNull) {
        if (this.valueIsNull.length <= this.positionCount) {
            this.growCapacity();
        }
        this.offsets[this.positionCount + 1] = this.values.getPositionCount();
        this.valueIsNull[this.positionCount] = isNull;
        this.hasNullValue |= isNull;
        ++this.positionCount;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(5);
        }
    }

    private void growCapacity() {
        int newSize;
        if (this.initialized) {
            newSize = BlockUtil.calculateNewArraySize(this.valueIsNull.length);
        } else {
            newSize = this.initialEntryCount;
            this.initialized = true;
        }
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.offsets = Arrays.copyOf(this.offsets, newSize + 1);
        this.updateDataSize();
    }

    private void updateDataSize() {
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf((boolean[])this.valueIsNull) + SizeOf.sizeOf((int[])this.offsets);
        if (this.blockBuilderStatus != null) {
            this.retainedSizeInBytes += (long)BlockBuilderStatus.INSTANCE_SIZE;
        }
    }

    @Override
    public BlockBuilder readPositionFrom(SliceInput input) {
        boolean isNull;
        boolean bl = isNull = input.readByte() == 0;
        if (isNull) {
            this.appendNull();
        } else {
            int length = input.readInt();
            SingleArrayBlockWriter singleArrayBlockWriter = this.beginBlockEntry();
            for (int i = 0; i < length; ++i) {
                singleArrayBlockWriter.readPositionFrom(input);
            }
            this.closeEntry();
        }
        return this;
    }

    @Override
    public ArrayBlock build() {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Current entry must be closed before the block can be built");
        }
        return ArrayBlock.createArrayBlockInternal(0, this.positionCount, this.hasNullValue ? this.valueIsNull : null, this.offsets, this.values.build());
    }

    @Override
    public BlockBuilder newBlockBuilderLike(BlockBuilderStatus blockBuilderStatus) {
        int newSize = BlockUtil.calculateBlockResetSize(this.getPositionCount());
        return new ArrayBlockBuilder(blockBuilderStatus, this.values.newBlockBuilderLike(blockBuilderStatus), newSize);
    }

    @Override
    public BlockBuilder newBlockBuilderLike(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        int newSize = Math.max(BlockUtil.calculateBlockResetSize(this.positionCount), expectedEntries);
        int valueExpectedEntries = BlockUtil.calculateNestedStructureResetSize(this.offsets[this.positionCount], this.positionCount, newSize);
        return new ArrayBlockBuilder(blockBuilderStatus, this.values.newBlockBuilderLike(blockBuilderStatus, valueExpectedEntries), newSize);
    }

    public String toString() {
        return String.format("ArrayBlockBuilder(%d){positionCount=%d}", this.hashCode(), this.getPositionCount());
    }
}

