/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.common.block;

import com.facebook.presto.common.block.ArrayBlockEncoding;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockEncoding;
import com.facebook.presto.common.block.BlockEncodingSerde;
import com.facebook.presto.common.block.ByteArrayBlockEncoding;
import com.facebook.presto.common.block.DictionaryBlockEncoding;
import com.facebook.presto.common.block.Int128ArrayBlockEncoding;
import com.facebook.presto.common.block.IntArrayBlockEncoding;
import com.facebook.presto.common.block.LazyBlockEncoding;
import com.facebook.presto.common.block.LongArrayBlockEncoding;
import com.facebook.presto.common.block.MapBlockEncoding;
import com.facebook.presto.common.block.RowBlockEncoding;
import com.facebook.presto.common.block.RunLengthBlockEncoding;
import com.facebook.presto.common.block.ShortArrayBlockEncoding;
import com.facebook.presto.common.block.SingleMapBlockEncoding;
import com.facebook.presto.common.block.SingleRowBlockEncoding;
import com.facebook.presto.common.block.VariableWidthBlockEncoding;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class BlockEncodingManager
implements BlockEncodingSerde {
    private final ConcurrentMap<String, BlockEncoding> blockEncodings = new ConcurrentHashMap<String, BlockEncoding>();

    public BlockEncodingManager() {
        this.addBlockEncoding(new VariableWidthBlockEncoding());
        this.addBlockEncoding(new ByteArrayBlockEncoding());
        this.addBlockEncoding(new ShortArrayBlockEncoding());
        this.addBlockEncoding(new IntArrayBlockEncoding());
        this.addBlockEncoding(new LongArrayBlockEncoding());
        this.addBlockEncoding(new Int128ArrayBlockEncoding());
        this.addBlockEncoding(new DictionaryBlockEncoding());
        this.addBlockEncoding(new ArrayBlockEncoding());
        this.addBlockEncoding(new MapBlockEncoding());
        this.addBlockEncoding(new SingleMapBlockEncoding());
        this.addBlockEncoding(new RowBlockEncoding());
        this.addBlockEncoding(new SingleRowBlockEncoding());
        this.addBlockEncoding(new RunLengthBlockEncoding());
        this.addBlockEncoding(new LazyBlockEncoding());
    }

    public void addBlockEncoding(BlockEncoding blockEncoding) {
        Objects.requireNonNull(blockEncoding, "blockEncoding is null");
        BlockEncoding existingEntry = this.blockEncodings.putIfAbsent(blockEncoding.getName(), blockEncoding);
        if (existingEntry != null) {
            throw new IllegalArgumentException(String.format("Encoding %s is already registered", blockEncoding.getName()));
        }
    }

    @Override
    public Block readBlock(SliceInput input) {
        String encodingName = BlockEncodingManager.readLengthPrefixedString(input);
        BlockEncoding blockEncoding = (BlockEncoding)this.blockEncodings.get(encodingName);
        if (blockEncoding == null) {
            throw new IllegalArgumentException(String.format("Unknown block encoding %s", encodingName));
        }
        return blockEncoding.readBlock(this, input);
    }

    @Override
    public void writeBlock(SliceOutput output, Block block) {
        String encodingName;
        BlockEncoding blockEncoding;
        Optional<Block> replacementBlock;
        while ((replacementBlock = (blockEncoding = (BlockEncoding)this.blockEncodings.get(encodingName = block.getEncodingName())).replacementBlockForWrite(block)).isPresent()) {
            block = replacementBlock.get();
        }
        BlockEncodingManager.writeLengthPrefixedString(output, encodingName);
        blockEncoding.writeBlock(this, output, block);
    }

    private static String readLengthPrefixedString(SliceInput input) {
        int length = input.readInt();
        byte[] bytes = new byte[length];
        input.readBytes(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static void writeLengthPrefixedString(SliceOutput output, String value) {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        output.writeInt(bytes.length);
        output.writeBytes(bytes);
    }
}

