/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.common;

import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Nullsafe;
import org.json.JSONException;
import org.json.JSONObject;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class DebugServerException
extends RuntimeException {
    private static final String GENERIC_ERROR_MESSAGE = "\n\nTry the following to fix the issue:\n\u2022 Ensure that Metro is running\n\u2022 Ensure that your device/emulator is connected to your machine and has USB debugging enabled - run 'adb devices' to see a list of connected devices\n\u2022 Ensure Airplane Mode is disabled\n\u2022 If you're on a physical device connected to the same machine, run 'adb reverse tcp:<PORT> tcp:<PORT>' to forward requests from your device\n\u2022 If your device is on the same Wi-Fi network, set 'Debug server host & port for device' in 'Dev settings' to your machine's IP address and the port of the local dev server - e.g. 10.0.1.1:<PORT>\n\n";
    private final String mOriginalMessage;

    public static DebugServerException makeGeneric(@NonNull String url, @NonNull String reason, Throwable t) {
        return DebugServerException.makeGeneric(url, reason, "", t);
    }

    public static DebugServerException makeGeneric(@NonNull String url, @NonNull String reason, @NonNull String extra, Throwable t) {
        Uri uri = Uri.parse((String)url);
        String message = GENERIC_ERROR_MESSAGE.replace("<PORT>", String.valueOf(uri.getPort()));
        return new DebugServerException(reason + message + extra, t);
    }

    private DebugServerException(String description, String fileName, int lineNumber, int column) {
        super(description + "\n  at " + fileName + ":" + lineNumber + ":" + column);
        this.mOriginalMessage = description;
    }

    public DebugServerException(String description) {
        super(description);
        this.mOriginalMessage = description;
    }

    public DebugServerException(String detailMessage, Throwable throwable) {
        super(detailMessage, throwable);
        this.mOriginalMessage = detailMessage;
    }

    public String getOriginalMessage() {
        return this.mOriginalMessage;
    }

    @Nullable
    public static DebugServerException parse(String url, String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return null;
        }
        try {
            JSONObject jsonObject = new JSONObject(str);
            String fullFileName = jsonObject.getString("filename");
            return new DebugServerException(jsonObject.getString("message"), DebugServerException.shortenFileName(fullFileName), jsonObject.getInt("lineNumber"), jsonObject.getInt("column"));
        }
        catch (JSONException e) {
            FLog.w((String)"ReactNative", (String)("Could not parse DebugServerException from: " + str), (Throwable)e);
            return null;
        }
    }

    private static String shortenFileName(String fullFileName) {
        String[] parts = fullFileName.split("/");
        return parts[parts.length - 1];
    }
}

