/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.common;

import com.facebook.infer.annotation.Nullsafe;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class LongArray {
    private static final double INNER_ARRAY_GROWTH_FACTOR = 1.8;
    private long[] mArray;
    private int mLength;

    public static LongArray createWithInitialCapacity(int initialCapacity) {
        return new LongArray(initialCapacity);
    }

    private LongArray(int initialCapacity) {
        this.mArray = new long[initialCapacity];
        this.mLength = 0;
    }

    public void add(long value) {
        this.growArrayIfNeeded();
        this.mArray[this.mLength++] = value;
    }

    public long get(int index) {
        if (index >= this.mLength) {
            throw new IndexOutOfBoundsException("" + index + " >= " + this.mLength);
        }
        return this.mArray[index];
    }

    public void set(int index, long value) {
        if (index >= this.mLength) {
            throw new IndexOutOfBoundsException("" + index + " >= " + this.mLength);
        }
        this.mArray[index] = value;
    }

    public int size() {
        return this.mLength;
    }

    public boolean isEmpty() {
        return this.mLength == 0;
    }

    public void dropTail(int n) {
        if (n > this.mLength) {
            throw new IndexOutOfBoundsException("Trying to drop " + n + " items from array of length " + this.mLength);
        }
        this.mLength -= n;
    }

    private void growArrayIfNeeded() {
        if (this.mLength == this.mArray.length) {
            int newSize = Math.max(this.mLength + 1, (int)((double)this.mLength * 1.8));
            long[] newArray = new long[newSize];
            System.arraycopy(this.mArray, 0, newArray, 0, this.mLength);
            this.mArray = newArray;
        }
    }
}

