/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.core;

import android.util.SparseArray;
import android.view.Choreographer;
import androidx.annotation.Nullable;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.common.SystemClock;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.jstasks.HeadlessJsTaskContext;
import com.facebook.react.modules.core.JavaScriptTimerExecutor;
import com.facebook.react.modules.core.ReactChoreographer;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.concurrent.atomic.AtomicBoolean;

public class JavaTimerManager {
    private static final float IDLE_CALLBACK_FRAME_DEADLINE_MS = 1.0f;
    private static final float FRAME_DURATION_MS = 16.666666f;
    private final ReactApplicationContext mReactApplicationContext;
    private final JavaScriptTimerExecutor mJavaScriptTimerExecutor;
    private final ReactChoreographer mReactChoreographer;
    private final DevSupportManager mDevSupportManager;
    private final Object mTimerGuard = new Object();
    private final Object mIdleCallbackGuard = new Object();
    private final PriorityQueue<Timer> mTimers;
    private final SparseArray<Timer> mTimerIdsToTimers;
    private final AtomicBoolean isPaused = new AtomicBoolean(true);
    private final AtomicBoolean isRunningTasks = new AtomicBoolean(false);
    private final TimerFrameCallback mTimerFrameCallback = new TimerFrameCallback();
    private final IdleFrameCallback mIdleFrameCallback = new IdleFrameCallback();
    @Nullable
    private IdleCallbackRunnable mCurrentIdleCallbackRunnable;
    private boolean mFrameCallbackPosted = false;
    private boolean mFrameIdleCallbackPosted = false;
    private boolean mSendIdleEvents = false;

    public JavaTimerManager(ReactApplicationContext reactContext, JavaScriptTimerExecutor javaScriptTimerManager, ReactChoreographer reactChoreographer, DevSupportManager devSupportManager) {
        this.mReactApplicationContext = reactContext;
        this.mJavaScriptTimerExecutor = javaScriptTimerManager;
        this.mReactChoreographer = reactChoreographer;
        this.mDevSupportManager = devSupportManager;
        this.mTimers = new PriorityQueue<Timer>(11, new Comparator<Timer>(){

            @Override
            public int compare(Timer lhs, Timer rhs) {
                long diff = lhs.mTargetTime - rhs.mTargetTime;
                if (diff == 0L) {
                    return 0;
                }
                if (diff < 0L) {
                    return -1;
                }
                return 1;
            }
        });
        this.mTimerIdsToTimers = new SparseArray();
    }

    public void onHostPause() {
        this.isPaused.set(true);
        this.clearFrameCallback();
        this.maybeIdleCallback();
    }

    public void onHostDestroy() {
        this.clearFrameCallback();
        this.maybeIdleCallback();
    }

    public void onHostResume() {
        this.isPaused.set(false);
        this.setChoreographerCallback();
        this.maybeSetChoreographerIdleCallback();
    }

    public void onHeadlessJsTaskStart(int taskId) {
        if (!this.isRunningTasks.getAndSet(true)) {
            this.setChoreographerCallback();
            this.maybeSetChoreographerIdleCallback();
        }
    }

    public void onHeadlessJsTaskFinish(int taskId) {
        HeadlessJsTaskContext headlessJsTaskContext = HeadlessJsTaskContext.getInstance(this.mReactApplicationContext);
        if (!headlessJsTaskContext.hasActiveTasks()) {
            this.isRunningTasks.set(false);
            this.clearFrameCallback();
            this.maybeIdleCallback();
        }
    }

    public void onInstanceDestroy() {
        this.clearFrameCallback();
        this.clearChoreographerIdleCallback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeSetChoreographerIdleCallback() {
        Object object = this.mIdleCallbackGuard;
        synchronized (object) {
            if (this.mSendIdleEvents) {
                this.setChoreographerIdleCallback();
            }
        }
    }

    private void maybeIdleCallback() {
        if (this.isPaused.get() && !this.isRunningTasks.get()) {
            this.clearFrameCallback();
        }
    }

    private void setChoreographerCallback() {
        if (!this.mFrameCallbackPosted) {
            this.mReactChoreographer.postFrameCallback(ReactChoreographer.CallbackType.TIMERS_EVENTS, this.mTimerFrameCallback);
            this.mFrameCallbackPosted = true;
        }
    }

    private void clearFrameCallback() {
        HeadlessJsTaskContext headlessJsTaskContext = HeadlessJsTaskContext.getInstance(this.mReactApplicationContext);
        if (this.mFrameCallbackPosted && this.isPaused.get() && !headlessJsTaskContext.hasActiveTasks()) {
            this.mReactChoreographer.removeFrameCallback(ReactChoreographer.CallbackType.TIMERS_EVENTS, this.mTimerFrameCallback);
            this.mFrameCallbackPosted = false;
        }
    }

    private void setChoreographerIdleCallback() {
        if (!this.mFrameIdleCallbackPosted) {
            this.mReactChoreographer.postFrameCallback(ReactChoreographer.CallbackType.IDLE_EVENT, this.mIdleFrameCallback);
            this.mFrameIdleCallbackPosted = true;
        }
    }

    private void clearChoreographerIdleCallback() {
        if (this.mFrameIdleCallbackPosted) {
            this.mReactChoreographer.removeFrameCallback(ReactChoreographer.CallbackType.IDLE_EVENT, this.mIdleFrameCallback);
            this.mFrameIdleCallbackPosted = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoNotStrip
    public void createTimer(int callbackID, long delay, boolean repeat) {
        long initialTargetTime = SystemClock.nanoTime() / 1000000L + delay;
        Timer timer = new Timer(callbackID, initialTargetTime, (int)delay, repeat);
        Object object = this.mTimerGuard;
        synchronized (object) {
            this.mTimers.add(timer);
            this.mTimerIdsToTimers.put(callbackID, (Object)timer);
        }
    }

    public void createAndMaybeCallTimer(int callbackID, int duration, double jsSchedulingTime, boolean repeat) {
        long driftTime;
        long deviceTime = SystemClock.currentTimeMillis();
        long remoteTime = (long)jsSchedulingTime;
        if (this.mDevSupportManager.getDevSupportEnabled() && (driftTime = Math.abs(remoteTime - deviceTime)) > 60000L) {
            this.mJavaScriptTimerExecutor.emitTimeDriftWarning("Debugger and device times have drifted by more than 60s. Please correct this by running adb shell \"date `date +%m%d%H%M%Y.%S`\" on your debugger machine.");
        }
        long adjustedDuration = Math.max(0L, remoteTime - deviceTime + (long)duration);
        if (duration == 0 && !repeat) {
            WritableArray timerToCall = Arguments.createArray();
            timerToCall.pushInt(callbackID);
            this.mJavaScriptTimerExecutor.callTimers(timerToCall);
            return;
        }
        this.createTimer(callbackID, adjustedDuration, repeat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoNotStrip
    public void deleteTimer(int timerId) {
        Object object = this.mTimerGuard;
        synchronized (object) {
            Timer timer = (Timer)this.mTimerIdsToTimers.get(timerId);
            if (timer == null) {
                return;
            }
            this.mTimerIdsToTimers.remove(timerId);
            this.mTimers.remove(timer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DoNotStrip
    public void setSendIdleEvents(final boolean sendIdleEvents) {
        Object object = this.mIdleCallbackGuard;
        synchronized (object) {
            this.mSendIdleEvents = sendIdleEvents;
        }
        UiThreadUtil.runOnUiThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = JavaTimerManager.this.mIdleCallbackGuard;
                synchronized (object) {
                    if (sendIdleEvents) {
                        JavaTimerManager.this.setChoreographerIdleCallback();
                    } else {
                        JavaTimerManager.this.clearChoreographerIdleCallback();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasActiveTimersInRange(long rangeMs) {
        Object object = this.mTimerGuard;
        synchronized (object) {
            Timer nextTimer = this.mTimers.peek();
            if (nextTimer == null) {
                return false;
            }
            if (JavaTimerManager.isTimerInRange(nextTimer, rangeMs)) {
                return true;
            }
            for (Timer timer : this.mTimers) {
                if (!JavaTimerManager.isTimerInRange(timer, rangeMs)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isTimerInRange(Timer timer, long rangeMs) {
        return !timer.mRepeat && (long)timer.mInterval < rangeMs;
    }

    private class TimerFrameCallback
    implements Choreographer.FrameCallback {
        @Nullable
        private WritableArray mTimersToCall = null;

        private TimerFrameCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFrame(long frameTimeNanos) {
            if (JavaTimerManager.this.isPaused.get() && !JavaTimerManager.this.isRunningTasks.get()) {
                return;
            }
            long frameTimeMillis = frameTimeNanos / 1000000L;
            Object object = JavaTimerManager.this.mTimerGuard;
            synchronized (object) {
                while (!JavaTimerManager.this.mTimers.isEmpty() && JavaTimerManager.this.mTimers.peek().mTargetTime < frameTimeMillis) {
                    Timer timer = JavaTimerManager.this.mTimers.poll();
                    if (this.mTimersToCall == null) {
                        this.mTimersToCall = Arguments.createArray();
                    }
                    this.mTimersToCall.pushInt(timer.mCallbackID);
                    if (timer.mRepeat) {
                        timer.mTargetTime = frameTimeMillis + (long)timer.mInterval;
                        JavaTimerManager.this.mTimers.add(timer);
                        continue;
                    }
                    JavaTimerManager.this.mTimerIdsToTimers.remove(timer.mCallbackID);
                }
            }
            if (this.mTimersToCall != null) {
                JavaTimerManager.this.mJavaScriptTimerExecutor.callTimers(this.mTimersToCall);
                this.mTimersToCall = null;
            }
            JavaTimerManager.this.mReactChoreographer.postFrameCallback(ReactChoreographer.CallbackType.TIMERS_EVENTS, this);
        }
    }

    private class IdleFrameCallback
    implements Choreographer.FrameCallback {
        private IdleFrameCallback() {
        }

        public void doFrame(long frameTimeNanos) {
            if (JavaTimerManager.this.isPaused.get() && !JavaTimerManager.this.isRunningTasks.get()) {
                return;
            }
            if (JavaTimerManager.this.mCurrentIdleCallbackRunnable != null) {
                JavaTimerManager.this.mCurrentIdleCallbackRunnable.cancel();
            }
            JavaTimerManager.this.mCurrentIdleCallbackRunnable = new IdleCallbackRunnable(frameTimeNanos);
            JavaTimerManager.this.mReactApplicationContext.runOnJSQueueThread(JavaTimerManager.this.mCurrentIdleCallbackRunnable);
            JavaTimerManager.this.mReactChoreographer.postFrameCallback(ReactChoreographer.CallbackType.IDLE_EVENT, this);
        }
    }

    private static class Timer {
        private final int mCallbackID;
        private final boolean mRepeat;
        private final int mInterval;
        private long mTargetTime;

        private Timer(int callbackID, long initialTargetTime, int duration, boolean repeat) {
            this.mCallbackID = callbackID;
            this.mTargetTime = initialTargetTime;
            this.mInterval = duration;
            this.mRepeat = repeat;
        }
    }

    private class IdleCallbackRunnable
    implements Runnable {
        private volatile boolean mCancelled = false;
        private final long mFrameStartTime;

        public IdleCallbackRunnable(long frameStartTime) {
            this.mFrameStartTime = frameStartTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean sendIdleEvents;
            if (this.mCancelled) {
                return;
            }
            long frameTimeMillis = this.mFrameStartTime / 1000000L;
            long timeSinceBoot = SystemClock.uptimeMillis();
            long frameTimeElapsed = timeSinceBoot - frameTimeMillis;
            long time = SystemClock.currentTimeMillis();
            long absoluteFrameStartTime = time - frameTimeElapsed;
            if (16.666666f - (float)frameTimeElapsed < 1.0f) {
                return;
            }
            Object object = JavaTimerManager.this.mIdleCallbackGuard;
            synchronized (object) {
                sendIdleEvents = JavaTimerManager.this.mSendIdleEvents;
            }
            if (sendIdleEvents) {
                JavaTimerManager.this.mJavaScriptTimerExecutor.callIdleCallbacks(absoluteFrameStartTime);
            }
            JavaTimerManager.this.mCurrentIdleCallbackRunnable = null;
        }

        public void cancel() {
            this.mCancelled = true;
        }
    }
}

