/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.events;

import android.view.Choreographer;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.modules.core.ReactChoreographer;
import com.facebook.react.uimanager.events.BatchEventDispatchedListener;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.uimanager.events.EventDispatcherListener;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.facebook.react.uimanager.events.RCTModernEventEmitter;
import com.facebook.react.uimanager.events.ReactEventEmitter;
import com.facebook.systrace.Systrace;
import java.util.concurrent.CopyOnWriteArrayList;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class FabricEventDispatcher
implements EventDispatcher,
LifecycleEventListener {
    private final ReactEventEmitter mReactEventEmitter;
    private final ReactApplicationContext mReactContext;
    private final CopyOnWriteArrayList<EventDispatcherListener> mListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<BatchEventDispatchedListener> mPostEventDispatchListeners = new CopyOnWriteArrayList();
    private final ScheduleDispatchFrameCallback mCurrentFrameCallback = new ScheduleDispatchFrameCallback();

    public FabricEventDispatcher(ReactApplicationContext reactContext) {
        this.mReactContext = reactContext;
        this.mReactContext.addLifecycleEventListener(this);
        this.mReactEventEmitter = new ReactEventEmitter(this.mReactContext);
    }

    @Override
    public void dispatchEvent(Event event) {
        for (EventDispatcherListener listener : this.mListeners) {
            listener.onEventDispatch(event);
        }
        event.dispatchModern(this.mReactEventEmitter);
        event.dispose();
        this.maybePostFrameCallbackFromNonUI();
    }

    @Override
    public void dispatchAllEvents() {
        this.maybePostFrameCallbackFromNonUI();
    }

    private void maybePostFrameCallbackFromNonUI() {
        if (this.mReactEventEmitter != null) {
            this.mCurrentFrameCallback.maybePostFromNonUI();
        }
    }

    @Override
    public void addListener(EventDispatcherListener listener) {
        this.mListeners.add(listener);
    }

    @Override
    public void removeListener(EventDispatcherListener listener) {
        this.mListeners.remove(listener);
    }

    @Override
    public void addBatchEventDispatchedListener(BatchEventDispatchedListener listener) {
        this.mPostEventDispatchListeners.add(listener);
    }

    @Override
    public void removeBatchEventDispatchedListener(BatchEventDispatchedListener listener) {
        this.mPostEventDispatchListeners.remove(listener);
    }

    @Override
    public void onHostResume() {
        this.maybePostFrameCallbackFromNonUI();
    }

    @Override
    public void onHostPause() {
        this.stopFrameCallback();
    }

    @Override
    public void onHostDestroy() {
        this.stopFrameCallback();
    }

    @Override
    public void onCatalystInstanceDestroyed() {
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                FabricEventDispatcher.this.stopFrameCallback();
            }
        });
    }

    private void stopFrameCallback() {
        UiThreadUtil.assertOnUiThread();
        this.mCurrentFrameCallback.stop();
    }

    @Override
    public void registerEventEmitter(int uiManagerType, RCTEventEmitter eventEmitter) {
        this.mReactEventEmitter.register(uiManagerType, eventEmitter);
    }

    @Override
    public void registerEventEmitter(int uiManagerType, RCTModernEventEmitter eventEmitter) {
        this.mReactEventEmitter.register(uiManagerType, eventEmitter);
    }

    @Override
    public void unregisterEventEmitter(int uiManagerType) {
        this.mReactEventEmitter.unregister(uiManagerType);
    }

    private class ScheduleDispatchFrameCallback
    implements Choreographer.FrameCallback {
        private volatile boolean mIsPosted = false;
        private boolean mShouldStop = false;

        private ScheduleDispatchFrameCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFrame(long frameTimeNanos) {
            UiThreadUtil.assertOnUiThread();
            if (this.mShouldStop) {
                this.mIsPosted = false;
            } else {
                this.post();
            }
            Systrace.beginSection(0L, "BatchEventDispatchedListeners");
            try {
                for (BatchEventDispatchedListener listener : FabricEventDispatcher.this.mPostEventDispatchListeners) {
                    listener.onBatchEventDispatched();
                }
            }
            finally {
                Systrace.endSection(0L);
            }
        }

        public void stop() {
            this.mShouldStop = true;
        }

        public void maybePost() {
            if (!this.mIsPosted) {
                this.mIsPosted = true;
                this.post();
            }
        }

        private void post() {
            ReactChoreographer.getInstance().postFrameCallback(ReactChoreographer.CallbackType.TIMERS_EVENTS, FabricEventDispatcher.this.mCurrentFrameCallback);
        }

        public void maybePostFromNonUI() {
            if (this.mIsPosted) {
                return;
            }
            if (FabricEventDispatcher.this.mReactContext.isOnUiQueueThread()) {
                this.maybePost();
            } else {
                FabricEventDispatcher.this.mReactContext.runOnUiQueueThread(new Runnable(){

                    @Override
                    public void run() {
                        ScheduleDispatchFrameCallback.this.maybePost();
                    }
                });
            }
        }
    }
}

