/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text.internal.span;

import android.content.res.AssetManager;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.text.TextPaint;
import android.text.style.MetricAffectingSpan;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.views.text.ReactTypefaceUtils;
import com.facebook.react.views.text.internal.span.ReactSpan;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class CustomStyleSpan
extends MetricAffectingSpan
implements ReactSpan {
    private final AssetManager mAssetManager;
    private final int mStyle;
    private final int mWeight;
    @Nullable
    private final String mFeatureSettings;
    @Nullable
    private final String mFontFamily;

    public CustomStyleSpan(int fontStyle, int fontWeight, @Nullable String fontFeatureSettings, @Nullable String fontFamily, AssetManager assetManager) {
        this.mStyle = fontStyle;
        this.mWeight = fontWeight;
        this.mFeatureSettings = fontFeatureSettings;
        this.mFontFamily = fontFamily;
        this.mAssetManager = assetManager;
    }

    public void updateDrawState(TextPaint ds) {
        CustomStyleSpan.apply((Paint)ds, this.mStyle, this.mWeight, this.mFeatureSettings, this.mFontFamily, this.mAssetManager);
    }

    public void updateMeasureState(TextPaint paint) {
        CustomStyleSpan.apply((Paint)paint, this.mStyle, this.mWeight, this.mFeatureSettings, this.mFontFamily, this.mAssetManager);
    }

    public int getStyle() {
        return this.mStyle == -1 ? 0 : this.mStyle;
    }

    public int getWeight() {
        return this.mWeight == -1 ? 400 : this.mWeight;
    }

    @Nullable
    public String getFontFamily() {
        return this.mFontFamily;
    }

    @Nullable
    public String getFontFeatureSettings() {
        return this.mFeatureSettings;
    }

    private static void apply(Paint paint, int style2, int weight, @Nullable String fontFeatureSettings, @Nullable String family, AssetManager assetManager) {
        Typeface typeface = ReactTypefaceUtils.applyStyles(paint.getTypeface(), style2, weight, family, assetManager);
        paint.setFontFeatureSettings(fontFeatureSettings);
        paint.setTypeface(typeface);
        paint.setSubpixelText(true);
    }
}

