/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import androidx.annotation.Nullable;
import com.facebook.react.animated.ValueAnimatedNode;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.bridge.UnexpectedNativeTypeException;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.events.RCTModernEventEmitter;
import com.facebook.react.uimanager.events.TouchEvent;
import java.util.List;

class EventAnimationDriver
implements RCTModernEventEmitter {
    private List<String> mEventPath;
    ValueAnimatedNode mValueNode;
    String mEventName;
    int mViewTag;

    public EventAnimationDriver(String eventName, int viewTag, List<String> eventPath, ValueAnimatedNode valueNode) {
        this.mEventName = eventName;
        this.mViewTag = viewTag;
        this.mEventPath = eventPath;
        this.mValueNode = valueNode;
    }

    @Override
    public void receiveEvent(int targetReactTag, String eventName, @Nullable WritableMap event) {
        this.receiveEvent(-1, targetReactTag, eventName, event);
    }

    @Override
    public void receiveEvent(int surfaceId, int targetTag, String eventName, @Nullable WritableMap event) {
        this.receiveEvent(surfaceId, targetTag, eventName, false, 0, event, 2);
    }

    @Override
    public void receiveTouches(String eventName, WritableArray touches, WritableArray changedIndices) {
        throw new UnsupportedOperationException("receiveTouches is not support by native animated events");
    }

    @Override
    public void receiveTouches(TouchEvent touchEvent) {
        throw new UnsupportedOperationException("receiveTouches is not support by native animated events");
    }

    @Override
    public void receiveEvent(int surfaceId, int targetTag, String eventName, boolean canCoalesceEvent, int customCoalesceKey, @Nullable WritableMap event, int category) {
        if (event == null) {
            throw new IllegalArgumentException("Native animated events must have event data.");
        }
        ReadableMap currMap = event;
        ReadableArray currArray = null;
        for (int i = 0; i < this.mEventPath.size() - 1; ++i) {
            ReadableType keyType;
            if (currMap != null) {
                String key = this.mEventPath.get(i);
                keyType = currMap.getType(key);
                if (keyType == ReadableType.Map) {
                    currMap = currMap.getMap(key);
                    currArray = null;
                    continue;
                }
                if (keyType == ReadableType.Array) {
                    currArray = currMap.getArray(key);
                    currMap = null;
                    continue;
                }
                throw new UnexpectedNativeTypeException("Unexpected type " + (Object)((Object)keyType) + " for key '" + key + "'");
            }
            int index = Integer.parseInt(this.mEventPath.get(i));
            keyType = currArray.getType(index);
            if (keyType == ReadableType.Map) {
                currMap = currArray.getMap(index);
                currArray = null;
                continue;
            }
            if (keyType == ReadableType.Array) {
                currArray = currArray.getArray(index);
                currMap = null;
                continue;
            }
            throw new UnexpectedNativeTypeException("Unexpected type " + (Object)((Object)keyType) + " for index '" + index + "'");
        }
        String lastKey = this.mEventPath.get(this.mEventPath.size() - 1);
        if (currMap != null) {
            this.mValueNode.mValue = currMap.getDouble(lastKey);
        } else {
            int lastIndex = Integer.parseInt(lastKey);
            this.mValueNode.mValue = currArray.getDouble(lastIndex);
        }
    }
}

